/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleVersion;

final class FactoriesByID {
    private static final SortedMap<ModuleVersion, ModuleFactory> EMPTY_MAP = Collections.unmodifiableSortedMap(FactoriesByID.createSortedMap());
    private Map<String, SortedMap<ModuleVersion, ModuleFactory>> map = Collections.emptyMap();

    private static final SortedMap<ModuleVersion, ModuleFactory> createSortedMap() {
        return new TreeMap<ModuleVersion, ModuleFactory>(Collections.reverseOrder());
    }

    public final synchronized Map<String, SortedMap<ModuleVersion, ModuleFactory>> getMap() {
        return this.map;
    }

    public String toString() {
        Map<String, SortedMap<ModuleVersion, ModuleFactory>> m = this.getMap();
        int size = m.size();
        StringBuilder sb = new StringBuilder(size * 32);
        sb.append(this.getClass().getSimpleName());
        if (size == 0) {
            sb.append(" empty");
        } else {
            sb.append(" {");
            for (Map.Entry<String, SortedMap<ModuleVersion, ModuleFactory>> e : m.entrySet()) {
                sb.append(e.getKey());
                sb.append(" : ");
                sb.append(e.getValue().keySet());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.map.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FactoriesByID other = (FactoriesByID)obj;
        return this.map.equals(other.map);
    }
}

