/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.CalendarCache;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;

public class HebrewCalendar
extends Calendar {
    private static final int[][] LIMITS = new int[][]{{0, 0, 0, 0}, {-5000000, -5000000, 5000000, 5000000}, {0, 0, 12, 12}, {1, 1, 51, 56}, new int[0], {1, 1, 29, 30}, {1, 1, 353, 385}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0]};
    private static final int[][] MONTH_LENGTH = new int[][]{{30, 30, 30}, {29, 29, 30}, {29, 30, 30}, {29, 29, 29}, {30, 30, 30}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}};
    private static final int[][] MONTH_START = new int[][]{{0, 0, 0}, {30, 30, 30}, {59, 59, 60}, {88, 89, 90}, {117, 118, 119}, {147, 148, 149}, {147, 148, 149}, {176, 177, 178}, {206, 207, 208}, {235, 236, 237}, {265, 266, 267}, {294, 295, 296}, {324, 325, 326}, {353, 354, 355}};
    private static final int[][] LEAP_MONTH_START = new int[][]{{0, 0, 0}, {30, 30, 30}, {59, 59, 60}, {88, 89, 90}, {117, 118, 119}, {147, 148, 149}, {177, 178, 179}, {206, 207, 208}, {236, 237, 238}, {265, 266, 267}, {295, 296, 297}, {324, 325, 326}, {354, 355, 356}, {383, 384, 385}};
    private static CalendarCache cache = new CalendarCache();

    public HebrewCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
    }

    public HebrewCalendar(TimeZone zone, ULocale locale) {
        super(zone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public void add(int field, int amount) {
        switch (field) {
            case 2: {
                int month = this.get(2);
                int year = this.get(1);
                if (amount > 0) {
                    boolean acrossAdar1 = month < 5;
                    month += amount;
                    while (true) {
                        if (acrossAdar1 && month >= 5 && !HebrewCalendar.isLeapYear(year)) {
                            ++month;
                        }
                        if (month > 12) {
                            month -= 13;
                            ++year;
                            acrossAdar1 = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    boolean acrossAdar1 = month > 5;
                    month += amount;
                    while (true) {
                        if (acrossAdar1 && month <= 5 && !HebrewCalendar.isLeapYear(year)) {
                            --month;
                        }
                        if (month >= 0) break;
                        month += 13;
                        --year;
                        acrossAdar1 = true;
                    }
                }
                this.set(2, month);
                this.set(1, year);
                this.pinField(5);
                break;
            }
            default: {
                super.add(field, amount);
            }
        }
    }

    private static long startOfYear(int year) {
        long day = cache.get(year);
        if (day == CalendarCache.EMPTY) {
            int months = (235 * year - 234) / 19;
            long frac = (long)months * 13753L + 12084L;
            day = (long)(months * 29) + frac / 25920L;
            frac %= 25920L;
            int wd = (int)(day % 7L);
            if (wd == 2 || wd == 4 || wd == 6) {
                wd = (int)(++day % 7L);
            }
            if (wd == 1 && frac > 16404L && !HebrewCalendar.isLeapYear(year)) {
                day += 2L;
            } else if (wd == 0 && frac > 23269L && HebrewCalendar.isLeapYear(year - 1)) {
                ++day;
            }
            cache.put(year, day);
        }
        return day;
    }

    private final int yearType(int year) {
        int yearLength = this.handleGetYearLength(year);
        if (yearLength > 380) {
            yearLength -= 30;
        }
        int type = 0;
        switch (yearLength) {
            case 353: {
                type = 0;
                break;
            }
            case 354: {
                type = 1;
                break;
            }
            case 355: {
                type = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal year length " + yearLength + " in year " + year);
            }
        }
        return type;
    }

    public static boolean isLeapYear(int year) {
        int x;
        return x >= ((x = (year * 12 + 17) % 19) < 0 ? -7 : 12);
    }

    private static int monthsInYear(int year) {
        return HebrewCalendar.isLeapYear(year) ? 13 : 12;
    }

    protected int handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    protected int handleGetMonthLength(int extendedYear, int month) {
        while (month < 0) {
            month += HebrewCalendar.monthsInYear(--extendedYear);
        }
        while (month > 12) {
            month -= HebrewCalendar.monthsInYear(extendedYear++);
        }
        switch (month) {
            case 1: 
            case 2: {
                return MONTH_LENGTH[month][this.yearType(extendedYear)];
            }
        }
        return MONTH_LENGTH[month][0];
    }

    protected int handleGetYearLength(int eyear) {
        return (int)(HebrewCalendar.startOfYear(eyear + 1) - HebrewCalendar.startOfYear(eyear));
    }

    protected void handleComputeFields(int julianDay) {
        long d = julianDay - 347997;
        long m = d * 25920L / 765433L;
        int year = (int)((19L * m + 234L) / 235L) + 1;
        long ys = HebrewCalendar.startOfYear(year);
        int dayOfYear = (int)(d - ys);
        while (dayOfYear < 1) {
            ys = HebrewCalendar.startOfYear(--year);
            dayOfYear = (int)(d - ys);
        }
        int yearType = this.yearType(year);
        int[][] monthStart = HebrewCalendar.isLeapYear(year) ? LEAP_MONTH_START : MONTH_START;
        int month = 0;
        while (dayOfYear > monthStart[month][yearType]) {
            ++month;
        }
        int dayOfMonth = dayOfYear - monthStart[--month][yearType];
        this.internalSet(0, 0);
        this.internalSet(1, year);
        this.internalSet(19, year);
        this.internalSet(2, month);
        this.internalSet(5, dayOfMonth);
        this.internalSet(6, dayOfYear);
    }

    protected int handleGetExtendedYear() {
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return year;
    }

    protected int handleComputeMonthStart(int eyear, int month, boolean useMonth) {
        while (month < 0) {
            month += HebrewCalendar.monthsInYear(--eyear);
        }
        while (month > 12) {
            month -= HebrewCalendar.monthsInYear(eyear++);
        }
        long day = HebrewCalendar.startOfYear(eyear);
        if (month != 0) {
            day = HebrewCalendar.isLeapYear(eyear) ? (day += (long)LEAP_MONTH_START[month][this.yearType(eyear)]) : (day += (long)MONTH_START[month][this.yearType(eyear)]);
        }
        return (int)(day + 347997L);
    }

    public String getType() {
        return "hebrew";
    }
}

