/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Norm2AllModes;
import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.text.UnicodeSet;

public final class Normalizer
implements Cloneable {
    private UCharacterIterator text;
    private Normalizer2 norm2;
    private Mode mode;
    private int options;
    private int currentIndex;
    private int nextIndex;
    private StringBuilder buffer;
    private int bufferPos;
    public static final Mode NONE = new NONEMode();
    public static final Mode NFD = new NFDMode();
    public static final Mode NFKD = new NFKDMode();
    public static final Mode NFC;
    public static final Mode DEFAULT;
    public static final Mode NFKC;
    public static final Mode FCD;
    public static final Mode NO_OP;
    public static final Mode COMPOSE;
    public static final Mode COMPOSE_COMPAT;
    public static final Mode DECOMP;
    public static final Mode DECOMP_COMPAT;
    public static final QuickCheckResult NO;
    public static final QuickCheckResult YES;
    public static final QuickCheckResult MAYBE;

    public Normalizer(String str, Mode mode, int opt) {
        this.text = UCharacterIterator.getInstance(str);
        this.mode = mode;
        this.options = opt;
        this.norm2 = mode.getNormalizer2(opt);
        this.buffer = new StringBuilder();
    }

    public Object clone() {
        try {
            Normalizer copy = (Normalizer)super.clone();
            copy.text = (UCharacterIterator)this.text.clone();
            copy.mode = this.mode;
            copy.options = this.options;
            copy.norm2 = this.norm2;
            copy.buffer = new StringBuilder(this.buffer);
            copy.bufferPos = this.bufferPos;
            copy.currentIndex = this.currentIndex;
            copy.nextIndex = this.nextIndex;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String normalize(String str, Mode mode, int options) {
        return mode.getNormalizer2(options).normalize(str);
    }

    public static String normalize(String src, Mode mode) {
        return Normalizer.normalize(src, mode, 0);
    }

    public static QuickCheckResult quickCheck(String source, Mode mode) {
        return Normalizer.quickCheck(source, mode, 0);
    }

    public static QuickCheckResult quickCheck(String source, Mode mode, int options) {
        return mode.getNormalizer2(options).quickCheck(source);
    }

    public static boolean isNormalized(String str, Mode mode, int options) {
        return mode.getNormalizer2(options).isNormalized(str);
    }

    public int next() {
        if (this.bufferPos < this.buffer.length() || this.nextNormalize()) {
            int c = this.buffer.codePointAt(this.bufferPos);
            this.bufferPos += Character.charCount(c);
            return c;
        }
        return -1;
    }

    public int getIndex() {
        if (this.bufferPos < this.buffer.length()) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    public int endIndex() {
        return this.text.getLength();
    }

    private void clearBuffer() {
        this.buffer.setLength(0);
        this.bufferPos = 0;
    }

    private boolean nextNormalize() {
        this.clearBuffer();
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.nextIndex);
        int c = this.text.nextCodePoint();
        if (c < 0) {
            return false;
        }
        StringBuilder segment = new StringBuilder().appendCodePoint(c);
        while ((c = this.text.nextCodePoint()) >= 0) {
            if (this.norm2.hasBoundaryBefore(c)) {
                this.text.moveCodePointIndex(-1);
                break;
            }
            segment.appendCodePoint(c);
        }
        this.nextIndex = this.text.getIndex();
        this.norm2.normalize(segment, this.buffer);
        return this.buffer.length() != 0;
    }

    static {
        DEFAULT = NFC = new NFCMode();
        NFKC = new NFKCMode();
        FCD = new FCDMode();
        NO_OP = NONE;
        COMPOSE = NFC;
        COMPOSE_COMPAT = NFKC;
        DECOMP = NFD;
        DECOMP_COMPAT = NFKD;
        NO = new QuickCheckResult(0);
        YES = new QuickCheckResult(1);
        MAYBE = new QuickCheckResult(2);
    }

    public static final class QuickCheckResult {
        private QuickCheckResult(int value) {
        }
    }

    private static final class FCDMode
    extends Mode {
        private FCDMode() {
        }

        protected Normalizer2 getNormalizer2(int options) {
            return (options & 0x20) != 0 ? FCD32ModeImpl.INSTANCE.normalizer2 : FCDModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFKCMode
    extends Mode {
        private NFKCMode() {
        }

        protected Normalizer2 getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFKC32ModeImpl.INSTANCE.normalizer2 : NFKCModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFCMode
    extends Mode {
        private NFCMode() {
        }

        protected Normalizer2 getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFC32ModeImpl.INSTANCE.normalizer2 : NFCModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFKDMode
    extends Mode {
        private NFKDMode() {
        }

        protected Normalizer2 getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFKD32ModeImpl.INSTANCE.normalizer2 : NFKDModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFDMode
    extends Mode {
        private NFDMode() {
        }

        protected Normalizer2 getNormalizer2(int options) {
            return (options & 0x20) != 0 ? NFD32ModeImpl.INSTANCE.normalizer2 : NFDModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NONEMode
    extends Mode {
        private NONEMode() {
        }

        protected Normalizer2 getNormalizer2(int options) {
            return Norm2AllModes.NOOP_NORMALIZER2;
        }
    }

    public static abstract class Mode {
        protected abstract Normalizer2 getNormalizer2(int var1);
    }

    private static final class FCD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getFCDNormalizer2(), Unicode32.access$100()));
    }

    private static final class NFKC32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFKCInstance().comp, Unicode32.access$100()));
    }

    private static final class NFC32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFCInstance().comp, Unicode32.access$100()));
    }

    private static final class NFKD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFKCInstance().decomp, Unicode32.access$100()));
    }

    private static final class NFD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getNFCInstance().decomp, Unicode32.access$100()));
    }

    private static final class Unicode32 {
        private static final UnicodeSet INSTANCE = new UnicodeSet("[:age=3.2:]").freeze();

        static /* synthetic */ UnicodeSet access$100() {
            return INSTANCE;
        }
    }

    private static final class FCDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getFCDNormalizer2());
    }

    private static final class NFKCModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFKCInstance().comp);
    }

    private static final class NFCModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFCInstance().comp);
    }

    private static final class NFKDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFKCInstance().decomp);
    }

    private static final class NFDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getNFCInstance().decomp);
    }

    private static final class ModeImpl {
        private final Normalizer2 normalizer2;

        private ModeImpl(Normalizer2 n2) {
            this.normalizer2 = n2;
        }
    }
}

