/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.OSFamily;
import org.openconcerto.utils.ProcessStreams;
import org.openconcerto.utils.PropertiesUtils;
import org.openconcerto.utils.prog.RemoteDebugArgs;

public abstract class VMLauncher {
    private static final NativeLauncherFinder UnknownLauncherFinder = new NativeLauncherFinder(){

        @Override
        public String getAppPath() {
            return null;
        }

        @Override
        public List<String> getCommand(List<String> args) {
            throw new UnsupportedOperationException();
        }
    };
    private static final Pattern NL = Pattern.compile("\\p{Cntrl}+");
    private File wd = null;

    private static NativeLauncherFinder getNativeAppLauncher() {
        OSFamily os = OSFamily.getInstance();
        NativeLauncherFinder l = os.equals(OSFamily.Windows) ? new WinLauncherFinder() : (os.equals(OSFamily.Mac) ? new MacLauncherFinder() : UnknownLauncherFinder);
        return l;
    }

    private static List<String> getNativeCommand(List<String> args) {
        NativeLauncherFinder l = VMLauncher.getNativeAppLauncher();
        return l.getAppPath() == null ? null : l.getCommand(args);
    }

    public static final Process restart(ProcessStreams.Action action, Class<?> mainClass, String ... args) throws IOException {
        return VMLauncher.restart(action, mainClass, Arrays.asList(args));
    }

    public static final Process restart(final ProcessStreams.Action action, Class<?> mainClass, List<String> args) throws IOException {
        if (Boolean.getBoolean("vm.noRestart")) {
            return null;
        }
        final File wd = FileUtils.getWD();
        List<String> command = VMLauncher.getNativeCommand(args);
        if (command != null) {
            return ProcessStreams.handle(new ProcessBuilder(command).directory(wd).start(), action);
        }
        try {
            mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(mainClass + " doesn't containt a main()", e);
        }
        return new VMLauncher(){

            @Override
            protected File getWD() {
                return wd;
            }

            @Override
            protected File getPropFile(String mainClass) {
                return null;
            }

            @Override
            protected ProcessStreams.Action getStreamAction() {
                return action;
            }
        }.launch(mainClass.getName(), args);
    }

    public final File getLauncherWD() {
        if (this.wd == null) {
            NativeLauncherFinder nativeAppLauncher = VMLauncher.getNativeAppLauncher();
            String appPath = nativeAppLauncher.getAppPath();
            this.wd = appPath != null ? new File(appPath).getAbsoluteFile().getParentFile() : (nativeAppLauncher.getFirstItem().equals(nativeAppLauncher.getClassPath()) && new File(nativeAppLauncher.getFirstItem()).isFile() ? new File(nativeAppLauncher.getFirstItem()).getParentFile() : FileUtils.getWD());
        }
        return this.wd;
    }

    private final List<String> split(String res) {
        if ((res = res.trim()).length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(NL.split(res));
    }

    private final List<String> getProp(File propFile, String propName) {
        return this.getProp(this.getProps(propFile), propName);
    }

    private final Properties getProps(File propFile) {
        if (propFile != null && propFile.canRead()) {
            try {
                return PropertiesUtils.createFromFile(propFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new Properties();
    }

    private final List<String> getProp(Properties props, String propName) {
        String res = "";
        if (props != null) {
            res = props.getProperty(propName, res);
        }
        return this.split(res);
    }

    protected final Process launch(String mainClass, List<String> progParams) throws IOException {
        String envVMArgs;
        boolean debug = Boolean.getBoolean("launcher.debug");
        String javaBinary = this.getJavaBinary();
        File sameJava = new File(System.getProperty("java.home"), "bin/" + javaBinary);
        String java = sameJava.canExecute() ? sameJava.getAbsolutePath() : javaBinary;
        File propFile = this.getPropFile(mainClass);
        Properties props = this.getProps(propFile);
        if (debug) {
            System.err.println("propFile : " + propFile);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(java);
        if (this.enableRemoteDebug(props)) {
            command.add(RemoteDebugArgs.getArgs());
        }
        command.addAll(this.getVMArguments());
        if (propFile != null) {
            List<String> appProps = this.getProp(props, "VMARGS");
            command.addAll(appProps);
            File userFile = new File(System.getProperty("user.home"), ".java/ilm/" + propFile.getName());
            List<String> userProps = this.getProp(userFile, "VMARGS");
            command.addAll(userProps);
            if (debug) {
                System.err.println("appProps : " + appProps);
                System.err.println("userProps ( from " + userFile + ") : " + userProps);
            }
        }
        if ((envVMArgs = System.getenv("JAVA_VMARGS")) != null) {
            command.addAll(this.split(envVMArgs));
        }
        command.add("-cp");
        command.add(this.getClassPath());
        command.add(mainClass);
        String envProgArgs = System.getenv("JAVA_PROGARGS");
        if (envProgArgs != null) {
            command.addAll(this.split(envProgArgs));
        }
        command.addAll(progParams);
        ProcessBuilder procBuilder = new ProcessBuilder(command).directory(this.getWD());
        this.modifyEnv(procBuilder.environment());
        if (debug) {
            System.err.println("Command line : " + procBuilder.command());
            System.err.println("Dir : " + procBuilder.directory());
            System.err.println("Std out and err :");
        }
        Process res = procBuilder.start();
        ProcessStreams.handle(res, debug ? ProcessStreams.Action.REDIRECT : this.getStreamAction());
        return res;
    }

    protected void modifyEnv(Map<String, String> environment) {
    }

    protected ProcessStreams.Action getStreamAction() {
        return ProcessStreams.Action.CLOSE;
    }

    protected boolean enableRemoteDebug(Properties props) {
        String prop = props.getProperty("remoteDebug");
        return prop == null ? this.remoteDebugDefault() : Boolean.parseBoolean(prop);
    }

    protected boolean remoteDebugDefault() {
        return false;
    }

    protected String getJavaBinary() {
        return OSFamily.getInstance() == OSFamily.Windows ? "javaw" : "java";
    }

    protected List<String> getVMArguments() {
        return Arrays.asList("-Dfile.encoding=UTF-8", "-Xms100M", "-Xmx256M");
    }

    protected String getClassPath() {
        return ManagementFactory.getRuntimeMXBean().getClassPath();
    }

    protected File getWD() {
        return this.getLauncherWD();
    }

    protected File getPropFile(String mainClass) {
        String className = mainClass.substring(mainClass.lastIndexOf(46) + 1);
        return new File(this.getWD(), String.valueOf(className) + ".properties");
    }

    private static class MacLauncherFinder
    extends NativeLauncherFinder {
        private static final Pattern MAC_PATTERN = Pattern.compile(String.valueOf(Pattern.quote(".app")) + "/Contents/Resources(/Java)?/[^/]+\\.jar$");

        private MacLauncherFinder() {
        }

        @Override
        public String getAppPath() {
            String appPath;
            File contentsDir;
            List<String> bundleContent;
            Matcher matcher = MAC_PATTERN.matcher(this.getFirstItem());
            if (matcher.matches() && (bundleContent = Arrays.asList((contentsDir = new File(appPath = this.getFirstItem().substring(0, matcher.start() + ".app".length()), "Contents")).list())).contains("Info.plist") && bundleContent.contains("PkgInfo") && new File(contentsDir, "MacOS").isDirectory()) {
                return appPath;
            }
            return null;
        }

        @Override
        public List<String> getCommand(List<String> args) {
            ArrayList<String> command = new ArrayList<String>(4 + args.size());
            command.add("open");
            command.add("-n");
            command.add(this.getAppPath());
            command.add("--args");
            command.addAll(args);
            return command;
        }
    }

    private static abstract class NativeLauncherFinder {
        private final String cp = ManagementFactory.getRuntimeMXBean().getClassPath();
        private final String firstItem;

        public NativeLauncherFinder() {
            int sepIndex = this.cp.indexOf(File.pathSeparatorChar);
            this.firstItem = sepIndex < 0 ? this.cp : this.cp.substring(0, sepIndex);
        }

        public final String getClassPath() {
            return this.cp;
        }

        public final String getFirstItem() {
            return this.firstItem;
        }

        public abstract String getAppPath();

        public abstract List<String> getCommand(List<String> var1);
    }

    private static class WinLauncherFinder
    extends NativeLauncherFinder {
        private WinLauncherFinder() {
        }

        @Override
        public String getAppPath() {
            if (this.getFirstItem().endsWith(".exe")) {
                return this.getFirstItem();
            }
            return null;
        }

        @Override
        public List<String> getCommand(List<String> args) {
            ArrayList<String> command = new ArrayList<String>(4 + args.size());
            command.add(this.getAppPath());
            command.addAll(args);
            return command;
        }
    }
}

