/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.convertor;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.convertor.DateTSConvertor;
import org.openconcerto.utils.convertor.DateToTimeConvertor;
import org.openconcerto.utils.convertor.NumberConvertor;
import org.openconcerto.utils.convertor.ReverseConvertor;
import org.openconcerto.utils.convertor.StringClobConvertor;
import org.openconcerto.utils.convertor.ValueConvertor;

public final class ValueConvertorFactory {
    private static final ValueConvertor IdentityConvertor = new ValueConvertor(){

        public Object convert(Object o) {
            return o;
        }

        public Object unconvert(Object o) {
            return o;
        }
    };
    private static final List<ValueConvertor<?, ?>> convs = new ArrayList();

    static {
        convs.add(new DateTSConvertor());
        convs.add(new DateToTimeConvertor());
        convs.add(StringClobConvertor.INSTANCE);
        convs.add(NumberConvertor.INT_TO_LONG);
        convs.add(NumberConvertor.SHORT_TO_INT);
    }

    public static final <T> ValueConvertor<T, T> getIdentityConvertor() {
        return IdentityConvertor;
    }

    public static final <T, U> ValueConvertor<T, U> find(Class<T> c1, Class<U> c2) {
        if (c1 == c2) {
            return ValueConvertorFactory.getIdentityConvertor();
        }
        for (ValueConvertor<?, ?> vc : convs) {
            List<Class<?>> args = ReflectUtils.getTypeArguments(vc, ValueConvertor.class);
            if (args.size() != 2) {
                throw new IllegalStateException(vc + " don't specify type arguments");
            }
            if (args.get(0).equals(c1) && args.get(1).equals(c2)) {
                return vc;
            }
            if (!args.get(0).equals(c2) || !args.get(1).equals(c1)) continue;
            return new ReverseConvertor(vc);
        }
        if (Number.class.isAssignableFrom(c1) && Number.class.isAssignableFrom(c2)) {
            return NumberConvertor.create(c1.asSubclass(Number.class), c2.asSubclass(Number.class), true);
        }
        return null;
    }
}

