/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.utils.Log;

public class StringUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16");
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset ISO8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset ISO8859_15 = Charset.forName("ISO-8859-15");
    public static final Charset Cp1252 = Charset.forName("Cp1252");
    public static final Charset Cp850 = Charset.forName("Cp850");
    private static final Pattern quotePatrn = Pattern.compile("\"", 16);
    private static final Pattern slashPatrn = Pattern.compile("(\\\\+)");

    public static String firstUpThenLow(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase();
    }

    public static String firstUp(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static String splitString(String s, int nbCharMaxLine) {
        if (s == null) {
            return s;
        }
        if (s.trim().length() < nbCharMaxLine) {
            return s;
        }
        StringBuffer lastString = new StringBuffer();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char charAt;
            if (lastString.length() == nbCharMaxLine) {
                int esp = lastString.lastIndexOf(" ");
                if (result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
                    result.append("\n");
                }
                if (esp > 0) {
                    result.append(lastString.substring(0, esp).toString().trim());
                    lastString = new StringBuffer(lastString.substring(esp, lastString.length()));
                } else {
                    result.append(lastString.toString().trim());
                    lastString = new StringBuffer();
                }
                result.append("\n");
            }
            if ((charAt = s.charAt(i)) == '\n') {
                lastString.append(charAt);
                result.append(lastString);
                lastString = new StringBuffer();
            } else {
                lastString.append(charAt);
            }
            ++i;
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
            result.append("\n");
        }
        result.append(lastString.toString().trim());
        return result.toString();
    }

    public static String doubleQuote(String s) {
        if (s.length() > 0) {
            s = slashPatrn.matcher(s).replaceAll("$1$1");
            s = quotePatrn.matcher(s).replaceAll("\\\\\"");
        }
        return String.valueOf('\"') + s + '\"';
    }

    public static String removeNonDecimalChars(String text) {
        int length = text.length();
        StringBuilder builder = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '+' || c == '-') {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    public static BigDecimal getBigDecimalFromUserText(String text) {
        if ((text = text.trim()).isEmpty() || text.equals("-")) {
            return BigDecimal.ZERO;
        }
        text = StringUtils.removeNonDecimalChars(text);
        BigDecimal result = null;
        try {
            result = new BigDecimal(text);
        }
        catch (Exception e) {
            Log.get().info(String.valueOf(text) + " is not a valid decimal");
        }
        return result;
    }

    public static final class Escaper {
        private final char esc;
        private final Map<Character, Character> substitution;
        private final Map<Character, Character> inv;

        public Escaper(char esc, char name) {
            this.esc = esc;
            this.substitution = new LinkedHashMap<Character, Character>();
            this.inv = new HashMap<Character, Character>();
            this.add(esc, name);
        }

        public Escaper add(char toRemove, char escapedName) {
            if (this.inv.containsKey(Character.valueOf(escapedName))) {
                throw new IllegalArgumentException(String.valueOf(escapedName) + " already replaces " + this.inv.get(Character.valueOf(escapedName)));
            }
            this.substitution.put(Character.valueOf(toRemove), Character.valueOf(escapedName));
            this.inv.put(Character.valueOf(escapedName), Character.valueOf(toRemove));
            return this;
        }

        public final Set<Character> getEscapedChars() {
            HashSet<Character> res = new HashSet<Character>(this.substitution.keySet());
            res.remove(Character.valueOf(this.esc));
            return res;
        }

        public final String escape(String s) {
            String res = s;
            for (Character toEsc : this.substitution.keySet()) {
                res = res.replace("" + toEsc, this.getEscaped(toEsc));
            }
            return res;
        }

        private String getEscaped(Character toEsc) {
            return String.valueOf(this.esc) + this.substitution.get(toEsc);
        }

        public final String unescape(String escaped) {
            String res = escaped;
            ArrayList<Character> toEscs = new ArrayList<Character>(this.substitution.keySet());
            Collections.reverse(toEscs);
            for (Character toEsc : toEscs) {
                res = res.replaceAll(this.getEscaped(toEsc), "" + toEsc);
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Escaper) {
                Escaper o = (Escaper)obj;
                return this.esc == o.esc && this.substitution.equals(o.substitution);
            }
            return false;
        }

        public int hashCode() {
            return this.esc + this.substitution.hashCode();
        }
    }
}

