/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openconcerto.utils.DropperQueue;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;

public class SleepingQueue {
    private final String name;
    private final PropertyChangeSupport support;
    private FutureTask<?> beingRun;
    private final SingleThreadedExecutor tasksQueue;
    private boolean canceling;
    private IPredicate<FutureTask<?>> cancelPredicate;

    public SleepingQueue() {
        this(String.valueOf(SleepingQueue.class.getName()) + System.currentTimeMillis());
    }

    public SleepingQueue(String name) {
        this.name = name;
        this.canceling = false;
        this.cancelPredicate = null;
        this.support = new PropertyChangeSupport(this);
        this.setBeingRun(null);
        this.tasksQueue = new SingleThreadedExecutor();
        this.tasksQueue.start();
    }

    protected void customizeThread(Thread thr) {
        thr.setPriority(1);
    }

    public final FutureTask<?> put(Runnable workRunnable) {
        if (this.shallAdd(workRunnable)) {
            IFutureTask t = this.tasksQueue.newTaskFor(workRunnable);
            this.add(t);
            return t;
        }
        return null;
    }

    public final <F extends FutureTask<?>> F execute(F t) {
        if (this.shallAdd(t)) {
            this.add(t);
            return t;
        }
        return null;
    }

    private void add(FutureTask<?> t) {
        if (this.dieCalled()) {
            throw new IllegalStateException("Already dead, cannot exec " + t);
        }
        this.tasksQueue.put(t);
    }

    private final boolean shallAdd(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("null runnable");
        }
        try {
            this.willPut(runnable);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void willPut(Runnable r) throws InterruptedException {
    }

    protected void exceptionThrown(ExecutionException exn) {
        exn.printStackTrace();
    }

    protected final void cancel(final IPredicate<FutureTask<?>> pred) {
        this.tasksDo(new IClosure<Collection<FutureTask<?>>>(){

            public void executeChecked(Collection<FutureTask<?>> tasks) {
                SleepingQueue.this.cancel(pred, tasks);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancel(IPredicate<FutureTask<?>> pred, Collection<FutureTask<?>> tasks) {
        try {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                this.canceling = true;
                this.cancelPredicate = pred;
                this.cancelCheck(this.getBeingRun());
            }
            for (FutureTask<?> t : tasks) {
                this.cancelCheck(t);
            }
        }
        catch (Throwable throwable) {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                this.canceling = false;
                this.cancelPredicate = null;
            }
            throw throwable;
        }
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            this.canceling = false;
            this.cancelPredicate = null;
        }
    }

    public final void tasksDo(IClosure<? super Deque<FutureTask<?>>> c) {
        this.tasksQueue.itemsDo(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelCheck(FutureTask<?> t) {
        if (t != null) {
            SleepingQueue sleepingQueue = this;
            synchronized (sleepingQueue) {
                if (this.canceling && (this.cancelPredicate == null || this.cancelPredicate.evaluateChecked(t))) {
                    t.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBeingRun(FutureTask<?> beingRun) {
        FutureTask<?> old;
        SleepingQueue sleepingQueue = this;
        synchronized (sleepingQueue) {
            old = this.beingRun;
            this.beingRun = beingRun;
        }
        this.support.firePropertyChange("beingRun", old, beingRun);
    }

    protected final synchronized FutureTask<?> getBeingRun() {
        return this.beingRun;
    }

    public boolean isSleeping() {
        return this.tasksQueue.isSleeping();
    }

    public boolean setSleeping(boolean sleeping) {
        boolean res = this.tasksQueue.setSleeping(sleeping);
        if (res) {
            this.support.firePropertyChange("sleeping", null, (Object)this.isSleeping());
        }
        return res;
    }

    public final Future<?> die() {
        return this.die(true, null, null);
    }

    public final <V> Future<V> die(final boolean force, final Runnable willDie, final Callable<V> dying) {
        final AtomicBoolean resetSleeping = new AtomicBoolean(false);
        final FutureTask res = new FutureTask(new Callable<V>(){

            @Override
            public V call() throws Exception {
                Exception willDieExn;
                block12: {
                    willDieExn = null;
                    try {
                        SleepingQueue.this.willDie();
                        if (willDie == null) break block12;
                        willDie.run();
                        if (!(willDie instanceof Future)) break block12;
                        Future f = (Future)((Object)willDie);
                        if (!$assertionsDisabled && !f.isDone()) {
                            throw new AssertionError((Object)("Ran but not done: " + f));
                        }
                        try {
                            f.get();
                        }
                        catch (ExecutionException e) {
                            throw (Exception)e.getCause();
                        }
                    }
                    catch (Exception e) {
                        if (!force) {
                            throw e;
                        }
                        willDieExn = e;
                    }
                }
                try {
                    SleepingQueue.this.tasksQueue.die(false);
                    if (!$assertionsDisabled && !SleepingQueue.this.tasksQueue.isDying()) {
                        throw new AssertionError();
                    }
                    if (willDieExn != null) {
                        throw willDieExn;
                    }
                    SleepingQueue.this.dying();
                    Object res = dying != null ? (Object)dying.call() : null;
                    Object v = res;
                    return v;
                }
                finally {
                    if (resetSleeping.get()) {
                        SleepingQueue.this.tasksQueue.setSleeping(true);
                    }
                }
            }
        });
        this.tasksQueue.itemsDo(new IClosure<Deque<FutureTask<?>>>(){

            public void executeChecked(Deque<FutureTask<?>> input) {
                input.clear();
                input.addFirst(res);
                FutureTask<?> beingRun = SleepingQueue.this.getBeingRun();
                if (!$assertionsDisabled && beingRun == res) {
                    throw new AssertionError((Object)("beingRun: " + beingRun + " ; res: " + res));
                }
                if (beingRun != null) {
                    beingRun.cancel(true);
                }
            }
        });
        resetSleeping.set(this.setSleeping(false));
        return res;
    }

    protected void willDie() {
    }

    protected void dying() {
    }

    public final boolean dieCalled() {
        return this.tasksQueue.dieCalled();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " Queue: " + this.tasksQueue + " run:" + this.getBeingRun();
    }

    private final class SingleThreadedExecutor
    extends DropperQueue<FutureTask<?>> {
        private SingleThreadedExecutor() {
            super(String.valueOf(SleepingQueue.this.name) + System.currentTimeMillis());
            SleepingQueue.this.customizeThread(this);
        }

        protected <T> IFutureTask<T> newTaskFor(Runnable task) {
            return this.newTaskFor(task, null);
        }

        protected <T> IFutureTask<T> newTaskFor(Runnable task, T value) {
            return new IFutureTask<T>(task, value, " for {" + SleepingQueue.this.name + "}");
        }

        @Override
        protected void process(FutureTask<?> task) {
            block3: {
                if (!task.isDone()) {
                    boolean ran = false;
                    this.beforeExecute(task);
                    try {
                        task.run();
                        ran = true;
                        this.afterExecute(task, null);
                    }
                    catch (RuntimeException ex) {
                        if (ran) break block3;
                        this.afterExecute(task, ex);
                    }
                }
            }
        }

        protected void beforeExecute(FutureTask<?> f) {
            SleepingQueue.this.cancelCheck(f);
            SleepingQueue.this.setBeingRun(f);
        }

        protected void afterExecute(FutureTask<?> f, Throwable t) {
            SleepingQueue.this.setBeingRun(null);
            try {
                f.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                SleepingQueue.this.exceptionThrown(e);
            }
        }
    }
}

