/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesUtils {
    public static final Properties createFromFile(File f) throws IOException {
        return PropertiesUtils.create(new BufferedInputStream(new FileInputStream(f)));
    }

    public static final Properties createFromResource(Class<?> ctxt, String rsrc) throws IOException {
        return PropertiesUtils.create(ctxt.getResourceAsStream(rsrc));
    }

    protected static final Properties create(InputStream stream) throws IOException {
        return PropertiesUtils.create(stream, true);
    }

    public static final Properties create(InputStream stream, boolean close) throws IOException {
        if (stream != null) {
            try {
                Properties res = new Properties();
                res.load(stream);
                Properties properties = res;
                return properties;
            }
            finally {
                if (close) {
                    stream.close();
                }
            }
        }
        return null;
    }
}

