/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.state;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EventListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.state.AbstractStateManager;
import org.openconcerto.utils.FileUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class ListenerXMLStateManager<T, L extends EventListener>
extends AbstractStateManager<T> {
    private L listener;

    public ListenerXMLStateManager(T src, File f, boolean autosave) {
        super(src, f, autosave);
    }

    @Override
    public final void beginAutoSave() {
        if (this.listener == null) {
            this.listener = this.createListener();
            this.addListener(this.listener);
        }
    }

    public final void endAutoSave() {
        if (this.listener != null) {
            this.rmListener(this.listener);
            this.listener = null;
        }
    }

    protected abstract L createListener();

    protected abstract void addListener(L var1);

    protected abstract void rmListener(L var1);

    @Override
    protected void writeState(File file) throws FileNotFoundException, IOException {
        BufferedWriter out = FileUtils.createXMLWriter(file);
        try {
            this.writeState(out);
        }
        finally {
            out.close();
        }
    }

    protected void writeState(BufferedWriter out) throws IOException {
        throw new UnsupportedOperationException("Override one of writeState() methods");
    }

    protected File getBadFile(File file) {
        return FileUtils.addSuffix(file, ".bad");
    }

    @Override
    protected final boolean readState(File file) {
        DocumentBuilder docBuilder;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
        InputSource is = new InputSource();
        try {
            is.setByteStream(new BufferedInputStream(new FileInputStream(file)));
            is.setSystemId(file.toURI().toASCIIString());
            Document doc = docBuilder.parse(is);
            is.getByteStream().close();
            doc.getDocumentElement().normalize();
            return this.readState(doc);
        }
        catch (Exception t) {
            String msg = file + " is not valid";
            if (is.getByteStream() != null) {
                File newFile = this.getBadFile(file);
                msg = String.valueOf(msg) + ", trying to rename it to " + newFile + " : ";
                try {
                    is.getByteStream().close();
                    newFile.delete();
                    msg = String.valueOf(msg) + file.renameTo(newFile);
                }
                catch (IOException e) {
                    msg = String.valueOf(msg) + e.getMessage();
                }
            }
            Log.get().warning(msg);
            t.printStackTrace();
            return false;
        }
    }

    protected abstract boolean readState(Document var1);
}

