/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.util.ArrayList;
import java.util.Set;
import javax.swing.JPanel;
import org.openconcerto.ui.preferences.PrefView;
import org.openconcerto.ui.preferences.PreferencePanel;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public abstract class JavaPrefPreferencePanel
extends JPanel
implements PreferencePanel {
    private final Set<PrefView<?>> views;
    private final ValidChangeSupport validSupp;

    @Override
    public ValidState getValidState() {
        boolean res = true;
        ArrayList<String> pbs = new ArrayList<String>();
        for (PrefView<?> v : this.views) {
            ValidState validState = v.getVW().getValidState();
            if (validState.isValid()) continue;
            String explanation = "'" + v.getName() + "' n'est pas valide";
            String txt = validState.getValidationText();
            if (txt != null) {
                explanation = String.valueOf(explanation) + " (" + txt + ")";
            }
            pbs.add(explanation);
            res = false;
        }
        return ValidState.create(res, CollectionUtils.join(pbs, "\n"));
    }

    @Override
    public final void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }
}

