/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.LayoutHints;

public class Item {
    private String id;
    private boolean frozen;
    private Group parent;
    private LayoutHints localHint;

    public Item(String id) {
        this(id, null);
    }

    public Item(String id, LayoutHints hint) {
        this.id = id.trim();
        this.frozen = false;
        this.setLocalHint(hint);
    }

    public final String getId() {
        return this.id;
    }

    public final synchronized boolean isFrozen() {
        return this.frozen;
    }

    protected final void checkFrozen(String op) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Frozen cannot " + op);
        }
    }

    final void setParent(Group parent) {
        this.checkFrozen("setParent");
        this.parent = parent;
    }

    public LayoutHints getLocalHint() {
        return this.localHint;
    }

    public void setLocalHint(LayoutHints localHint) {
        this.checkFrozen("setLocalHint");
        this.localHint = new LayoutHints(localHint == null ? LayoutHints.DEFAULT_FIELD_HINTS : localHint);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " '" + this.getId() + "'";
    }
}

