/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.coreanimation;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.openconcerto.ui.coreanimation.JComponentAnimator;
import org.openconcerto.ui.coreanimation.Pulse;

public class JComponentBackGroundAnimator
extends JComponentAnimator
implements Pulse {
    private static final Color[] COLORS = new Color[a.length];
    private final Color bgColor;
    private final Boolean opaque;

    static {
        int i = 0;
        while (i < a.length) {
            JComponentBackGroundAnimator.COLORS[i] = new Color(255, 255 - a[i] / 30, 255 - a[i] / 5);
            ++i;
        }
    }

    public JComponentBackGroundAnimator(JComponent f) {
        this(f, false);
    }

    public JComponentBackGroundAnimator(JComponent f, boolean setOpaque) {
        super(f);
        Color color = this.bgColor = f.isBackgroundSet() ? f.getBackground() : null;
        if (setOpaque) {
            this.opaque = f.isOpaque();
            f.setOpaque(true);
        } else {
            this.opaque = null;
        }
    }

    @Override
    protected void setColor(int i) {
        this.chk.setBackground(COLORS[i]);
    }

    public String toString() {
        return "BGA:" + this.chk.getClass();
    }

    @Override
    public void resetState() {
        this.chk.setBackground(this.bgColor);
        boolean hadFocus = this.chk.hasFocus();
        if (this.chk.isEnabled()) {
            this.chk.setEnabled(false);
            this.chk.setEnabled(true);
        } else {
            this.chk.setEnabled(true);
            this.chk.setEnabled(false);
        }
        if (this.opaque != null) {
            this.chk.setOpaque(this.opaque);
        }
        if (hadFocus) {
            final FocusListener[] listeners = this.chk.getFocusListeners();
            int i = 0;
            while (i < listeners.length) {
                FocusListener focusListener = listeners[i];
                this.chk.removeFocusListener(focusListener);
                ++i;
            }
            this.chk.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    JComponentBackGroundAnimator.this.chk.removeFocusListener(this);
                    int i = 0;
                    while (i < listeners.length) {
                        FocusListener focusListener = listeners[i];
                        JComponentBackGroundAnimator.this.chk.addFocusListener(focusListener);
                        ++i;
                    }
                }
            });
            this.chk.requestFocus();
        }
    }
}

