/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.coreanimation;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.ui.component.ComboComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.coreanimation.JComponentBackGroundAnimator;
import org.openconcerto.ui.coreanimation.JComponentForegroundAnimator;
import org.openconcerto.ui.coreanimation.Pulse;
import org.openconcerto.ui.coreanimation.Pulseable;

public class Animator {
    private Pulse[] tmpAnims = new Pulse[0];
    private final Vector<Pulse> animators = new Vector();
    private Thread thread = null;
    private boolean isAnimating = true;
    private final Map<Component, Pulse> activeComps = new HashMap<Component, Pulse>();
    private final Map<Component, Object> managedComps = new WeakHashMap<Component, Object>();
    private final DisplayabilityListener displayabilityListener = new DisplayabilityListener(){

        @Override
        protected void displayabilityChanged(Component c) {
            Animator.this.updateComp(c);
        }
    };
    private static final Animator instance = new Animator();

    private Animator() {
    }

    public static final synchronized Animator getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pulse() {
        int size;
        assert (SwingUtilities.isEventDispatchThread());
        Vector<Pulse> vector = this.animators;
        synchronized (vector) {
            size = this.animators.size();
            if (this.tmpAnims.length > size + 128) {
                this.tmpAnims = new Pulse[size + 8];
            }
            this.tmpAnims = this.animators.toArray(this.tmpAnims);
        }
        int i = 0;
        while (i < size) {
            this.tmpAnims[i].pulse();
            this.tmpAnims[i] = null;
            ++i;
        }
    }

    public synchronized boolean isAnimating() {
        return this.isAnimating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Pulse p) {
        boolean res;
        assert (SwingUtilities.isEventDispatchThread());
        Vector<Pulse> vector = this.animators;
        synchronized (vector) {
            res = this.animators.remove(p);
        }
        if (res) {
            p.resetState();
        }
        return res;
    }

    public void remove(Component c) {
        this.remove(c, true);
    }

    private void remove(Component c, boolean completely) {
        assert (SwingUtilities.isEventDispatchThread());
        this.remove(this.activeComps.remove(c));
        if (completely) {
            c.removeHierarchyListener(this.displayabilityListener);
            this.managedComps.remove(c);
        }
    }

    private void put(Component f, Pulse pulse) {
        assert (SwingUtilities.isEventDispatchThread());
        this.activeComps.put(f, pulse);
        this.add(pulse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(Pulse p) {
        if (p == null) {
            throw new NullPointerException("null Pulse");
        }
        Vector<Pulse> vector = this.animators;
        synchronized (vector) {
            if (this.animators.contains(p)) {
                return;
            }
            this.animators.add(p);
            this.animators.notify();
        }
        if (this.thread == null) {
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Runnable pulseRunnable = new Runnable(){

                        @Override
                        public void run() {
                            Animator.this.pulse();
                        }
                    };
                    while (Animator.this.isAnimating()) {
                        try {
                            Vector vector = Animator.this.animators;
                            synchronized (vector) {
                                while (Animator.this.animators.size() == 0) {
                                    Animator.this.animators.wait();
                                }
                            }
                            SwingUtilities.invokeLater(pulseRunnable);
                            Thread.sleep(100L, 0);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, String.valueOf(this.getClass().getSimpleName()) + " pulse");
            this.thread.setName("Background Animator");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void animate(Component f, boolean animate) {
        if (animate) {
            this.animate(f);
        } else {
            this.remove(f);
        }
    }

    public boolean animate(Component f) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.managedComps.containsKey(f)) {
            return this.activeComps.containsKey(f);
        }
        this.managedComps.put(f, null);
        f.addHierarchyListener(this.displayabilityListener);
        return this.updateComp(f);
    }

    private final boolean updateComp(Component f) {
        assert (SwingUtilities.isEventDispatchThread());
        boolean res = false;
        if (f.isDisplayable()) {
            Collection<? extends Component> pc = f instanceof Pulseable ? ((Pulseable)((Object)f)).getPulseComponents() : Arrays.asList(f);
            Pulse p = this.createPulseFromList(pc);
            if (p != null) {
                this.put(f, p);
                res = true;
            }
        } else {
            this.remove(f, false);
        }
        return res;
    }

    private Pulse createPulseFromList(Collection<? extends Component> comps) {
        LinkedList<Pulse> l = new LinkedList<Pulse>();
        for (Component component : comps) {
            Pulse p = this.createPulse(component);
            if (p == null) continue;
            l.add(p);
        }
        return l.size() == 0 ? null : new MultiPulse(l);
    }

    private Pulse createPulse(Component f) {
        Pulse res = null;
        if (f instanceof JToggleButton) {
            res = new JComponentForegroundAnimator((JToggleButton)f);
        } else if (f instanceof JComboBox) {
            res = this.createComboPulse((JComboBox)f);
        } else if (f instanceof ComboComponent && ((ComboComponent)((Object)f)).getComboComp() != null) {
            res = this.createComboPulse(((ComboComponent)((Object)f)).getComboComp());
        } else if (f instanceof JTextComponent) {
            res = new JComponentBackGroundAnimator((JTextComponent)f);
        } else if (f instanceof TextComponent && this.bkgdUseable((TextComponent)((Object)f))) {
            res = new JComponentBackGroundAnimator(((TextComponent)((Object)f)).getTextComp());
        } else if (f instanceof JPanel) {
            res = new JComponentBackGroundAnimator((JPanel)f);
        }
        return res;
    }

    private final boolean bkgdUseable(TextComponent t) {
        return t.getTextComp() != null && (t.getTextComp().isOpaque() || UIManager.getLookAndFeel().getName().equals("Mac OS X") || UIManager.getLookAndFeel().getName().equals("Nimbus"));
    }

    private final Pulse createComboPulse(JComboBox comp) {
        if (comp.isEditable()) {
            JComponent editor = (JComponent)comp.getEditor().getEditorComponent();
            return new JComponentBackGroundAnimator(editor, true);
        }
        return new JComponentForegroundAnimator(comp);
    }

    private static class MultiPulse
    implements Pulse {
        private final List<Pulse> l;

        private MultiPulse(List<Pulse> l) {
            this.l = l;
        }

        @Override
        public void pulse() {
            for (Pulse p : this.l) {
                p.pulse();
            }
        }

        @Override
        public void resetState() {
            for (Pulse p : this.l) {
                p.resetState();
            }
        }
    }
}

