/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.i18n.TM;

public final class JDate
extends JXDatePicker
implements TextComponent,
ValueWrapper<Date> {
    private static boolean CommitEachValidEditDefault;
    private final boolean fillWithCurrentDate;
    private final boolean commitEachValidEdit;

    static {
        String formats = TM.getInstance().translate(TM.MissingMode.NULL, "jdate.formats", new Object[0]);
        if (formats != null) {
            String[] array = formats.split("\n");
            UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
            if (array.length > 0) {
                lafDefaults.put("JXDatePicker.longFormat", array[0]);
            }
            if (array.length > 1) {
                lafDefaults.put("JXDatePicker.mediumFormat", array[1]);
            }
            if (array.length > 2) {
                lafDefaults.put("JXDatePicker.shortFormat", array[2]);
            }
            if (array.length > 3) {
                Log.get().warning("Some formats ignored " + formats);
            }
        }
        CommitEachValidEditDefault = false;
    }

    public static boolean getCommitEachValidEditDefault() {
        return CommitEachValidEditDefault;
    }

    public JDate() {
        this(false);
    }

    public JDate(boolean fillWithCurrentDate) {
        this(fillWithCurrentDate, JDate.getCommitEachValidEditDefault());
    }

    public JDate(boolean fillWithCurrentDate, boolean commitEachValidEdit) {
        this.fillWithCurrentDate = fillWithCurrentDate;
        this.commitEachValidEdit = commitEachValidEdit;
        InputMap inputMap = this.getEditor().getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "dayToFuture");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "dayToPast");
        inputMap.put(KeyStroke.getKeyStroke(38, 512), "monthToFuture");
        inputMap.put(KeyStroke.getKeyStroke(40, 512), "monthToPast");
        ActionMap actionMap = this.getEditor().getActionMap();
        Calendar cal = Calendar.getInstance(this.getMonthView().getLocale());
        actionMap.put("dayToPast", this.createChangeDateAction(cal, 6, -1));
        actionMap.put("dayToFuture", this.createChangeDateAction(cal, 6, 1));
        actionMap.put("monthToPast", this.createChangeDateAction(cal, 2, -1));
        actionMap.put("monthToFuture", this.createChangeDateAction(cal, 2, 1));
        this.resetValue();
    }

    public final boolean fillsWithCurrentDate() {
        return this.fillWithCurrentDate;
    }

    protected AbstractAction createChangeDateAction(final Calendar cal, final int field, final int amount) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date currentVal = JDate.this.getDate();
                if (currentVal == null && JDate.this.fillsWithCurrentDate()) {
                    currentVal = new Date();
                }
                if (currentVal != null) {
                    cal.setTime(currentVal);
                    cal.add(field, amount);
                    JDate.this.setDate(cal.getTime());
                }
            }
        };
    }

    @Override
    public final void resetValue() {
        if (this.fillsWithCurrentDate()) {
            this.setValue(new Date());
        } else {
            this.setValue(null);
        }
    }

    @Override
    public final void setValue(Date date) {
        this.setDate(date);
    }

    @Override
    public final Date getValue() {
        return this.getDate();
    }

    public final boolean isEmpty() {
        return this.getValue() == null;
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.getEditor().addPropertyChangeListener("value", l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public JTextComponent getTextComp() {
        return this.getEditor();
    }
}

