/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.search;

import java.text.Format;
import java.text.Normalizer;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.FormatGroup;

public class TextSearchSpec
implements SearchSpec {
    private static final Pattern thoroughPattern = Pattern.compile("(\\p{Punct}|\\p{InCombiningDiacriticalMarks})+");
    private static final Pattern multipleSpacesPattern = Pattern.compile("\\p{Space}+");
    private final Mode mode;
    private final String filterString;
    private final String normalizedFilterString;
    private final Map<Class<?>, FormatGroup> formats;
    private final Map<Format, Object> parsedFilter;
    private Double parsedFilterD;
    private boolean parsedFilterD_tried = false;

    public TextSearchSpec(String filterString, Mode mode) {
        this.mode = mode;
        this.filterString = filterString;
        this.normalizedFilterString = this.normalize(filterString);
        this.formats = new HashMap();
        this.parsedFilter = new HashMap<Format, Object>();
    }

    private String normalize(String s) {
        if (this.mode == Mode.CONTAINS_STRICT || this.mode == Mode.EQUALS_STRICT) {
            return s.trim();
        }
        String sansAccents = thoroughPattern.matcher(Normalizer.normalize(s.trim(), Normalizer.Form.NFD)).replaceAll("");
        return multipleSpacesPattern.matcher(sansAccents).replaceAll(" ").toLowerCase();
    }

    private final Object getParsed(Format fmt) {
        Object res;
        if (this.parsedFilter.containsKey(fmt)) {
            res = this.parsedFilter.get(fmt);
        } else {
            ParsePosition pp = new ParsePosition(0);
            res = fmt.parseObject(this.filterString, pp);
            if (pp.getErrorIndex() >= 0 || pp.getIndex() < this.filterString.length()) {
                res = null;
            } else assert (res != null) : "Cannot tell apart parsing failed from parsed to null";
            this.parsedFilter.put(fmt, res);
        }
        return res;
    }

    private final Double getDouble() {
        if (!this.parsedFilterD_tried) {
            try {
                this.parsedFilterD = Double.valueOf(this.filterString);
            }
            catch (NumberFormatException e) {
                this.parsedFilterD = null;
            }
            this.parsedFilterD_tried = true;
        }
        return this.parsedFilterD;
    }

    private boolean matchWithFormats(Object cell) {
        if (cell == null) {
            return false;
        }
        if (cell.getClass() == String.class) {
            return this.test(cell.toString());
        }
        boolean containsOrEquals = this.isContainsOrEquals();
        boolean isContains = this.isContains();
        if (containsOrEquals && this.containsOrEquals(cell.toString())) {
            return true;
        }
        FormatGroup fg = this.getFormat(cell);
        if (fg != null) {
            List<? extends Format> fmts = fg.getFormats();
            int stop = fmts.size();
            int i = 0;
            while (i < stop) {
                Format fmt = fmts.get(i);
                if (isContains && this.containsOrEquals(fmt.format(cell))) {
                    return true;
                }
                if (!isContains && this.test(this.getParsed(fmt), cell)) {
                    return true;
                }
                ++i;
            }
        } else if (!isContains && cell instanceof Number) {
            Number n = (Number)cell;
            if (this.test(this.getDouble(), n.doubleValue())) {
                return true;
            }
        }
        return false;
    }

    private boolean test(String searched) {
        String normalized = this.normalize(searched);
        if (this.isContains()) {
            return normalized.indexOf(this.normalizedFilterString) >= 0;
        }
        if (this.mode == Mode.EQUALS || this.mode == Mode.EQUALS_STRICT) {
            return normalized.equals(this.normalizedFilterString);
        }
        if (this.mode == Mode.LESS_THAN) {
            return normalized.compareTo(this.normalizedFilterString) <= 0;
        }
        if (this.mode == Mode.GREATER_THAN) {
            return normalized.compareTo(this.normalizedFilterString) >= 0;
        }
        throw new IllegalArgumentException("unknown mode " + (Object)((Object)this.mode));
    }

    private boolean isContainsOrEquals() {
        return this.mode != Mode.LESS_THAN && this.mode != Mode.GREATER_THAN;
    }

    private boolean isContains() {
        return this.mode == Mode.CONTAINS || this.mode == Mode.CONTAINS_STRICT;
    }

    private boolean containsOrEquals(String searched) {
        if (this.isContains()) {
            return searched.indexOf(this.filterString) >= 0;
        }
        assert (this.mode == Mode.EQUALS || this.mode == Mode.EQUALS_STRICT) : "Only call contains() if isContainsOrEquals()";
        return searched.equals(this.filterString);
    }

    private boolean test(Object search, Object cell) {
        assert (this.mode != Mode.CONTAINS && this.mode != Mode.CONTAINS_STRICT) : "Only call test() if not isContains()";
        if (search == null) {
            return false;
        }
        if (cell instanceof Comparable) {
            Comparable c = (Comparable)cell;
            if (this.mode == Mode.EQUALS || this.mode == Mode.EQUALS_STRICT) {
                return c.compareTo(search) == 0;
            }
            if (this.mode == Mode.LESS_THAN) {
                return c.compareTo(search) <= 0;
            }
            assert (this.mode == Mode.GREATER_THAN);
            return c.compareTo(search) >= 0;
        }
        if (this.mode == Mode.EQUALS || this.mode == Mode.EQUALS_STRICT) {
            return cell.equals(search);
        }
        return false;
    }

    private FormatGroup getFormat(Object cell) {
        Class<?> clazz = cell.getClass();
        if (!this.formats.containsKey(clazz)) {
            this.formats.put(clazz, this.findFormat(clazz));
        }
        return this.formats.get(clazz);
    }

    private FormatGroup findFormat(Class<?> clazz) {
        Class<?> c = clazz;
        FormatGroup res = null;
        while (res == null && c != Object.class) {
            res = this.formats.get(c);
            c = c.getSuperclass();
        }
        return res;
    }

    @Override
    public boolean match(Object line) {
        return this.isEmpty() || this.matchWithFormats(line);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ":" + this.filterString;
    }

    @Override
    public boolean isEmpty() {
        return this.filterString == null || this.filterString.length() == 0;
    }

    public void setFormats(Map<Class<?>, FormatGroup> formats) {
        this.formats.clear();
        this.formats.putAll(formats);
    }

    public static enum Mode {
        CONTAINS,
        CONTAINS_STRICT,
        LESS_THAN,
        EQUALS,
        EQUALS_STRICT,
        GREATER_THAN;

    }
}

