/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.LineListener;
import org.openconcerto.sql.view.list.ListAccess;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.search.ChangeListAll;
import org.openconcerto.sql.view.list.search.ChangeListOne;
import org.openconcerto.sql.view.list.search.SearchAll;
import org.openconcerto.sql.view.list.search.SearchOne;
import org.openconcerto.sql.view.list.search.SearchRunnable;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;

public final class SearchQueue
extends SleepingQueue {
    private final ITableModel model;
    SearchSpec search;
    private final List<ListSQLLine> fullList;
    private final ListAccess listAccess;
    private final LineListener lineListener;

    public static boolean isSearch(FutureTask<?> f) {
        return f instanceof IFutureTask && ((IFutureTask)f).getRunnable() instanceof SearchRunnable;
    }

    public static String getLastReferentField(Path p) {
        Step lastStep = p.length() == 0 ? null : p.getStep(-1);
        boolean lastIsForeign = lastStep == null || lastStep.getDirection() == Link.Direction.FOREIGN;
        return lastIsForeign ? null : lastStep.getSingleField().getName();
    }

    public SearchQueue(ListAccess la) {
        super(String.valueOf(SearchQueue.class.getName()) + " on " + la.getModel());
        this.listAccess = la;
        this.model = la.getModel();
        this.search = null;
        this.fullList = new ArrayList<ListSQLLine>();
        this.lineListener = new LineListener(){

            @Override
            public void lineChanged(int id, ListSQLLine l, Set<Integer> colIndex) {
                SearchQueue.this.changeFullList(id, l, colIndex);
            }
        };
        this.getModel().getLinesSource().addLineListener(this.lineListener);
    }

    @Override
    protected void willDie() {
        this.getModel().getLinesSource().rmLineListener(this.lineListener);
        super.willDie();
    }

    public ListMap<Path, ListSQLLine> getAffectedPaths(SQLRow r) {
        return this.execGetAffected(r, new ListMap(), false);
    }

    private <K, V> ListMap<K, V> execGetAffected(final SQLRow r, final ListMap<K, V> res, final boolean byLine) {
        return (ListMap)this.execute(new Callable<ListMap<K, V>>(){

            @Override
            public ListMap<K, V> call() throws Exception {
                return SearchQueue.this.getAffected(r, res, byLine);
            }
        });
    }

    private <R> R execute(Callable<R> c) {
        try {
            return this.execute(new FutureTask<R>(c)).get();
        }
        catch (InterruptedException e) {
            throw new RTInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private <K, V> ListMap<K, V> getAffected(SQLRow r, ListMap<K, V> res, boolean byLine) {
        final SQLTable t = r.getTable();
        int id = r.getID();
        if (id < 0) {
            throw new IllegalArgumentException("invalid ID: " + id);
        }
        if (!this.fullList.isEmpty()) {
            SQLRowValues proto = this.getModel().getLinesSource().getParent().getMaxGraph();
            ArrayList pathsToT = new ArrayList();
            proto.getGraph().walk(proto, pathsToT, new ITransformer<SQLRowValuesCluster.State<List<Path>>, List<Path>>(){

                public List<Path> transformChecked(SQLRowValuesCluster.State<List<Path>> input) {
                    if (input.getCurrent().getTable() == t) {
                        input.getAcc().add(input.getPath());
                    }
                    return input.getAcc();
                }
            }, RecursionType.BREADTH_FIRST, Link.Direction.ANY);
            for (Path p : pathsToT) {
                String lastReferentField = SearchQueue.getLastReferentField(p);
                for (ListSQLLine line : this.fullList) {
                    boolean put = false;
                    for (SQLRowValues current : line.getRow().followPath(p, SQLRowValues.CreateMode.CREATE_NONE, false)) {
                        if (current == null || current.getID() != id) continue;
                        put = true;
                    }
                    if (!put && lastReferentField != null && r.exists()) {
                        int foreignID = r.getInt(lastReferentField);
                        for (SQLRowValues current : line.getRow().followPath(p.minusLast(), SQLRowValues.CreateMode.CREATE_NONE, false)) {
                            if (current.getID() != foreignID) continue;
                            put = true;
                        }
                    }
                    if (!put) continue;
                    this.add(byLine, res, p, line);
                }
            }
        }
        return res;
    }

    <V, K> void add(boolean byLine, ListMap<K, V> res, Path p, ListSQLLine line) {
        if (byLine) {
            res.add(line, p);
        } else {
            res.add((ListSQLLine)((Object)p), (Path)((Object)line));
        }
    }

    private synchronized void changeFullList(int id, ListSQLLine modifiedLine, Collection<Integer> modifiedCols) {
        SearchOne oneSearchRunnable = new SearchOne(this, id, modifiedLine, modifiedCols);
        this.putTask(new ChangeListOne("changeFullList " + id + " newLine: " + modifiedLine, this, modifiedLine, id, oneSearchRunnable));
        this.putTask(oneSearchRunnable);
    }

    public synchronized void setFullList(List<ListSQLLine> l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.putTask(new ChangeListAll("setFullList", this, l));
        this.fullDataChange();
    }

    public synchronized void setSearch(final SearchSpec s) {
        this.putTask(new Runnable(){

            @Override
            public void run() {
                SearchQueue.this.search = s;
            }
        });
        this.fullDataChange();
    }

    private synchronized void fullDataChange() {
        this.clearCompute();
        this.putTask(new SearchAll(this));
    }

    private synchronized void putTask(Runnable r) {
        this.execute(new IFutureTask<Object>(r, null));
    }

    private synchronized void clearCompute() {
        this.cancel(new IPredicate<FutureTask<?>>(){

            @Override
            public boolean evaluateChecked(FutureTask<?> f) {
                return SearchQueue.isSearch(f);
            }
        });
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " for " + this.getModel();
    }

    final SearchSpec getSearch() {
        return this.search;
    }

    final List<ListSQLLine> getFullList() {
        return this.fullList;
    }

    final ListAccess getAccess() {
        return this.listAccess;
    }

    public final int getFullListSize() {
        return this.fullList.size();
    }

    public final ITableModel getModel() {
        return this.model;
    }
}

