/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.view.list.ChangeAllRunnable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.UpdateAllRunnable;
import org.openconcerto.sql.view.list.UpdateOneRunnable;
import org.openconcerto.sql.view.list.UpdateQueue;
import org.openconcerto.sql.view.list.search.SearchQueue;

abstract class UpdateRunnable
implements Runnable {
    private final ITableModel model;
    private final SQLRow row;

    static UpdateRunnable create(ITableModel model) {
        return new UpdateAllRunnable(model);
    }

    static UpdateRunnable createRmAll(UpdateQueue updateQueue, ITableModel tableModel) {
        return new RmAllRunnable(tableModel, updateQueue);
    }

    static UpdateRunnable create(ITableModel model, SQLTableEvent evt) {
        return new UpdateOneRunnable(model, evt);
    }

    protected UpdateRunnable(ITableModel model, SQLRow r) {
        this.model = model;
        this.row = r;
    }

    public final String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + this.hashCode() + " " + this.getTable() + "[" + this.getID() + "] on " + this.model;
    }

    protected final ITableModel getModel() {
        return this.model;
    }

    protected final SQLTableModelLinesSource getReq() {
        return this.getModel().getLinesSource();
    }

    protected final SearchQueue getSearchQ() {
        return this.getModel().getSearchQueue();
    }

    protected final SQLRow getRow() {
        return this.row;
    }

    protected final SQLTable getTable() {
        return this.getRow().getTable();
    }

    protected final int getID() {
        return this.getRow().getID();
    }

    static final class RmAllRunnable
    extends ChangeAllRunnable {
        private final UpdateQueue updateQueue;

        private RmAllRunnable(ITableModel model, UpdateQueue updateQueue) {
            super(model);
            this.updateQueue = updateQueue;
        }

        @Override
        protected List<ListSQLLine> getList() {
            return Collections.emptyList();
        }

        @Override
        protected void done() {
            this.updateQueue.setSleeping(true);
        }
    }
}

