/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collection;
import java.util.List;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.AbstractUpdateOneRunnable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.utils.ListMap;

final class UpdateOneRunnable
extends AbstractUpdateOneRunnable {
    private final SQLTableEvent evt;

    public UpdateOneRunnable(ITableModel model, SQLTableEvent evt) {
        super(model, evt.getRow());
        this.evt = evt;
    }

    @Override
    public void run() {
        if (this.getTable() == this.getReq().getParent().getPrimaryTable()) {
            ListSQLLine line = this.getReq().get(this.getID());
            if (line == null) {
                this.getReq().fireLineChanged(this.getID(), line, null);
            }
            ListMap<Path, ListSQLLine> affectedPaths = this.getAffectedPaths();
            if (line != null && ((List)affectedPaths.getNonNull(Path.get(this.getTable()))).isEmpty()) {
                line.clearCache();
            }
            this.updateLines(affectedPaths);
        } else {
            this.updateLines(this.getAffectedPaths());
        }
    }

    @Override
    protected Collection<String> getModifedFields() {
        return this.evt.getFieldNames();
    }
}

