/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelLinesSourceOnline;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.change.ListChangeIndex;

public class SQLTableModelSourceOnline
extends SQLTableModelSource {
    private final ListSQLRequest req;

    public SQLTableModelSourceOnline(ListSQLRequest req) {
        super(req.getGraph());
        this.req = req;
    }

    public final ListSQLRequest getReq() {
        return this.req;
    }

    @Override
    protected void colsChanged(ListChangeIndex<SQLTableModelColumn> change) {
        super.colsChanged(change);
        for (SQLTableModelColumn col : change.getItemsAdded()) {
            for (IFieldPath iFieldPath : col.getPaths()) {
                SQLRowValues assurePath = this.getReq().getGraphToFetch().followPathToOne(iFieldPath.getPath(), SQLRowValues.CreateMode.CREATE_ONE, false);
                if (assurePath.getFields().contains(iFieldPath.getFieldName())) continue;
                assurePath.put(iFieldPath.getFieldName(), null);
            }
        }
    }

    @Override
    protected SQLTableModelLinesSourceOnline _createLinesSource(ITableModel model) {
        return new SQLTableModelLinesSourceOnline(this, model);
    }

    @Override
    public SQLRowValues getMaxGraph() {
        return this.getReq().getGraphToFetch();
    }
}

