/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.change.ListChangeIndex;
import org.openconcerto.utils.change.ListChangeRecorder;

public abstract class SQLTableModelSource {
    private final SQLTable table;
    private SQLRowValues inited;
    private final List<SQLTableModelColumn> allCols;
    private final ListChangeRecorder<SQLTableModelColumn> cols;
    private final Map<String, SQLTableModelColumn> colsByName;
    private final List<WeakReference<SQLTableModelLinesSource>> lines;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    public SQLTableModelSource(SQLRowValues graph) {
        this.lines = new ArrayList<WeakReference<SQLTableModelLinesSource>>();
        this.table = graph.getTable();
        this.allCols = new ArrayList<SQLTableModelColumn>();
        this.cols = new ListChangeRecorder(new ArrayList());
        this.colsByName = new HashMap<String, SQLTableModelColumn>();
        this.inited = graph;
    }

    private void init() {
        if (this.inited == null) {
            return;
        }
        SQLRowValues graph = this.inited;
        this.listenToCols();
        graph.walkFields(new IClosure<FieldPath>(){

            public void executeChecked(FieldPath input) {
                SQLField f = input.getField();
                if (f.getTable().getLocalContentFields().contains(f)) {
                    SQLTableModelColumnPath col = new SQLTableModelColumnPath(input);
                    SQLTableModelSource.this.cols.add(col);
                } else {
                    SQLTableModelSource.this.allCols.add(new SQLTableModelColumnPath(input.getPath(), f.getName(), f.toString()){

                        @Override
                        protected Object show_(SQLRowAccessor r) {
                            Object res = super.show_(r);
                            return res instanceof SQLRowValues ? Integer.valueOf(((SQLRowValues)res).getID()) : res;
                        }
                    });
                }
            }
        }, true);
        this.allCols.add(new BaseSQLTableModelColumn("Fields", Object.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                if (r instanceof SQLRow) {
                    return r;
                }
                return new SQLRowValues((SQLRowValues)r, SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM);
            }

            @Override
            public Set<SQLField> getFields() {
                return SQLTableModelSource.this.getPrimaryTable().getFields();
            }

            @Override
            public Set<FieldPath> getPaths() {
                return FieldPath.create(Path.get(SQLTableModelSource.this.getPrimaryTable()), SQLTableModelSource.this.getPrimaryTable().getFieldsName());
            }
        });
        this.allCols.add(new SQLTableModelColumnPath(Path.get(this.getPrimaryTable()), this.getPrimaryTable().getKey().getName(), "PrimaryKey"));
        this.inited = null;
    }

    private void listenToCols() {
        this.cols.getRecipe().bind(this.allCols);
        this.cols.getRecipe().addListener(new IClosure<ListChangeIndex<SQLTableModelColumn>>(){

            public void executeChecked(ListChangeIndex<SQLTableModelColumn> change) {
                for (SQLTableModelColumn col : change.getItemsRemoved()) {
                    SQLTableModelSource.this.colsByName.remove(col.getName());
                }
                for (SQLTableModelColumn col : change.getItemsAdded()) {
                    SQLTableModelSource.this.colsByName.put(col.getName(), col);
                }
                SQLTableModelSource.this.colsChanged(change);
                SQLTableModelSource.this.fireColsChanged();
            }
        });
    }

    protected void colsChanged(ListChangeIndex<SQLTableModelColumn> change) {
    }

    private void fireColsChanged() {
        if (this.inited != null) {
            return;
        }
        int i = 0;
        while (i < this.lines.size()) {
            WeakReference<SQLTableModelLinesSource> l = this.lines.get(i);
            SQLTableModelLinesSource line = (SQLTableModelLinesSource)l.get();
            if (line == null) {
                this.lines.remove(i);
                continue;
            }
            line.colsChanged();
            ++i;
        }
        this.supp.firePropertyChange("cols", null, this.cols);
    }

    public final SQLTableModelLinesSource createLinesSource(ITableModel model) {
        SQLTableModelLinesSource res = this._createLinesSource(model);
        this.lines.add(new WeakReference<SQLTableModelLinesSource>(res));
        return res;
    }

    protected abstract SQLTableModelLinesSource _createLinesSource(ITableModel var1);

    public abstract SQLRowValues getMaxGraph();

    public final List<SQLTableModelColumn> getColumns() {
        this.init();
        return this.cols;
    }

    public final List<SQLTableModelColumn> getAllColumns() {
        this.init();
        return Collections.unmodifiableList(this.allCols);
    }

    public final SQLTableModelColumn getColumn(int index) {
        return this.getAllColumns().get(index);
    }

    public final List<SQLTableModelColumn> getColumns(SQLField f) {
        ArrayList<SQLTableModelColumn> res = new ArrayList<SQLTableModelColumn>();
        for (SQLTableModelColumn col : this.getColumns()) {
            if (!col.getFields().contains(f)) continue;
            res.add(col);
        }
        return res;
    }

    public final void addColumnListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("cols", l);
    }

    public final void rmColumnListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("cols", l);
    }

    public final SQLTable getPrimaryTable() {
        return this.table;
    }

    public final Set<SQLTable> getTables() {
        return new SQLFieldsSet(this.getLineFields()).getTables();
    }

    public final Set<SQLField> getLineFields() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (SQLRowValues v : this.getMaxGraph().getGraph().getItems()) {
            for (String f : v.getFields()) {
                res.add(v.getTable().getField(f));
            }
            if (!v.getTable().isArchivable()) continue;
            res.add(v.getTable().getArchiveField());
        }
        return res;
    }
}

