/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.KeyTableCellRenderer;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.ui.TextAreaRenderer;
import org.openconcerto.ui.TextAreaTableCellEditor;
import org.openconcerto.ui.TimeStampTableCellEditor;
import org.openconcerto.utils.CompareUtils;

public class SQLTableElement {
    private Class<?> typeClass;
    private String rowField;
    private final SQLField field;
    private CellDynamicModifier modifier;
    private String name;
    private TableCellEditor editor;
    private TableCellRenderer renderer;
    private SQLBase base;
    private boolean isEditable;
    private boolean addElement = false;
    private boolean chooseInListe = false;
    private int preferredSize = 70;
    private boolean addUndefined = false;
    private SQLTextComboTableCellEditor comboBox = null;
    private Where w;
    private SQLRowValues defaultRowValues = null;
    private List<SQLTableElement> modificationListener = new Vector<SQLTableElement>();
    private int EMPTY_ID = 1;
    int decimalDigits = -1;

    public SQLTableElement(SQLField field, Class<?> classe, TableCellEditor editor) {
        this(field, classe);
        this.editor = editor;
    }

    public int getDecimalDigits() {
        if (this.decimalDigits < 0) {
            this.decimalDigits = this.field.getType().getDecimalDigits();
        }
        return this.decimalDigits;
    }

    public SQLTableElement(SQLField field, boolean addUndefined, boolean addElement, boolean chooseInListe) {
        this(field, addUndefined, addElement);
        this.chooseInListe = chooseInListe;
    }

    public SQLTableElement(SQLField field, boolean addUndefined, boolean addElement) {
        this(field);
        this.EMPTY_ID = field.getTable().getUndefinedID();
        this.addUndefined = addUndefined;
        this.addElement = addElement;
    }

    public int getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(int size) {
        this.preferredSize = size;
    }

    public SQLTableElement(SQLField field, Class<?> classe) {
        this.base = field.getTable().getBase();
        this.typeClass = classe == null ? (field.isKey() ? Integer.class : String.class) : classe;
        this.rowField = field.getName();
        this.field = field;
        this.name = Configuration.getInstance().getTranslator().getTitleFor(field);
        this.isEditable = field != null;
    }

    public SQLTableElement(SQLField field) {
        this(field, field.getType().getJavaType());
    }

    public String toString() {
        return "SQLTableElement: " + this.name + " class:" + this.typeClass + ", rowField:" + this.rowField + " field:" + this.field;
    }

    public TableCellEditor getTableCellEditor(JTable table) {
        if (this.editor != null) {
            return this.editor;
        }
        if (this.field != null && this.field.isKey()) {
            SQLTable fTable = this.base.getGraph().getForeignTable(this.field);
            final SQLElement element = Configuration.getInstance().getDirectory().getElement(fTable);
            this.comboBox = new SQLTextComboTableCellEditor(element, this.addUndefined, this.chooseInListe);
            if (this.addElement) {
                AbstractAction abstractAction = new AbstractAction("Ajouter"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EditFrame frame = new EditFrame(element, EditFrame.CREATION);
                        if (SQLTableElement.this.defaultRowValues != null) {
                            frame.getPanel().getSQLComponent().select(SQLTableElement.this.defaultRowValues);
                        }
                        frame.pack();
                        frame.setVisible(true);
                    }
                };
                this.comboBox.addAction(abstractAction);
            }
            if (this.w != null) {
                this.comboBox.setWhere(this.w);
            }
            this.editor = this.comboBox;
            return this.comboBox;
        }
        if (this.field != null) {
            if (this.field.getType().getJavaType() == String.class) {
                TextAreaTableCellEditor textEditor = new TextAreaTableCellEditor(table);
                textEditor.setLimitedSize(this.field.getType().getSize());
                return textEditor;
            }
            if (this.field.getType().getJavaType() == Timestamp.class) {
                TimeStampTableCellEditor textEditor = new TimeStampTableCellEditor();
                return textEditor;
            }
        }
        return null;
    }

    public TableCellRenderer getTableCellRenderer() {
        if (this.renderer != null) {
            return this.renderer;
        }
        if (this.field != null && this.field.isKey() && !this.field.isPrimaryKey()) {
            SQLTable fTable = this.base.getGraph().getForeignTable(this.field);
            if (fTable == null) {
                throw new IllegalStateException("No foreign table for field:" + this.field.getFullName());
            }
            SQLElement element = Configuration.getInstance().getDirectory().getElement(fTable);
            return new KeyTableCellRenderer(element);
        }
        if (this.field != null && this.field.getType().getJavaType() == String.class) {
            return new TextAreaRenderer();
        }
        return null;
    }

    public Class<?> getElementClass() {
        return this.typeClass;
    }

    public final SQLField getField() {
        return this.field;
    }

    protected String getRowField() {
        return this.rowField;
    }

    protected Object getDefaultNullValue() {
        return null;
    }

    public Object convertEditorValueToModel(Object value, SQLRowValues row) {
        if (this.field != null && this.field.isKey()) {
            Number v = (Number)value;
            if (v == null || v.longValue() < 0L) {
                return this.field.getTable().getUndefinedID();
            }
            return v;
        }
        if (value == null && this.getDefaultNullValue() != null) {
            return this.getDefaultNullValue();
        }
        return value;
    }

    public void fireModification(SQLRowValues row) {
        int i = 0;
        while (i < this.modificationListener.size()) {
            SQLTableElement element = this.modificationListener.get(i);
            element.valueModified(row);
            ++i;
        }
    }

    private void valueModified(SQLRowValues row) {
        Object newValue;
        Object oldValue;
        if (this.modifier != null && !CompareUtils.equals(oldValue = row.getObject(this.rowField), newValue = this.modifier.computeValueFrom(row))) {
            if (this.rowField != null) {
                row.put(this.rowField, newValue);
            }
            this.modifier.setValueFrom(row, newValue);
            this.fireModification(row);
        }
    }

    protected CellDynamicModifier getModifier() {
        return this.modifier;
    }

    public String getColumnName() {
        return this.name;
    }

    public void setEditor(TableCellEditor aTableCellEditor) {
        this.editor = aTableCellEditor;
    }

    public void setRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
    }

    public void setModifier(CellDynamicModifier modifier2) {
        this.modifier = modifier2;
    }

    public Object getValueFrom(SQLRowValues row) {
        Object result = this.getModifier() != null ? this.getModifier().getValueFrom(row) : row.getObject(this.getRowField());
        return result;
    }

    public void setValueFrom(SQLRowValues row, Object value) {
        if (this.getModifier() != null) {
            this.getModifier().setValueFrom(row, value);
        }
        if (this.getRowField() != null) {
            row.put(this.getRowField(), value);
        }
        this.fireModification(row);
    }

    public void addModificationListener(SQLTableElement tableElement) {
        if (!this.modificationListener.contains(tableElement)) {
            this.modificationListener.add(tableElement);
        }
    }

    public boolean isCellEditable(SQLRowValues vals) {
        return this.isEditable;
    }

    public void clear() {
        if (this.modifier != null) {
            this.modifier.clear();
        }
    }
}

