/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.OrderComparator;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.Tuple2;

public final class MoveQueue
extends SleepingQueue {
    private final ITableModel tableModel;

    MoveQueue(ITableModel model) {
        super(String.valueOf(MoveQueue.class.getSimpleName()) + " on " + model);
        this.tableModel = model;
    }

    public void move(List<? extends SQLRowAccessor> rows, final int inc) {
        if (inc == 0 || rows.size() == 0) {
            return;
        }
        final boolean after = inc > 0;
        final ArrayList<? extends SQLRowAccessor> l = new ArrayList<SQLRowAccessor>(rows);
        Collections.sort(l, after ? Collections.reverseOrder(OrderComparator.INSTANCE) : OrderComparator.INSTANCE);
        final int id = ((SQLRowAccessor)l.get(0)).getID();
        this.put(new Runnable(){

            @Override
            public void run() {
                final FutureTask<ListSQLLine> destID = new FutureTask<ListSQLLine>(new Callable<ListSQLLine>(){

                    @Override
                    public ListSQLLine call() {
                        return MoveQueue.this.tableModel.getDestLine(id, inc);
                    }
                });
                MoveQueue.this.tableModel.invokeLater(destID);
                try {
                    if (destID.get() != null) {
                        SQLUtils.executeAtomic(MoveQueue.this.tableModel.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                            @Override
                            public Object handle(SQLDataSource ds) throws Exception {
                                MoveQueue.this.moveQuick(l, after, ((ListSQLLine)destID.get()).getRow().asRow());
                                return null;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                }
            }
        });
    }

    public void moveTo(final List<? extends SQLRowAccessor> rows, final int rowIndex) {
        if (rows.size() == 0) {
            return;
        }
        this.put(new Runnable(){

            @Override
            public void run() {
                FutureTask<Tuple2<Boolean, ListSQLLine>> future = new FutureTask<Tuple2<Boolean, ListSQLLine>>(new Callable<Tuple2<Boolean, ListSQLLine>>(){

                    @Override
                    public Tuple2<Boolean, ListSQLLine> call() {
                        if (!$assertionsDisabled && rowIndex < 0) {
                            throw new AssertionError();
                        }
                        int rowCount = MoveQueue.this.tableModel.getRowCount();
                        boolean after = rowIndex >= rowCount;
                        int index = after ? rowCount - 1 : rowIndex;
                        return Tuple2.create(after, MoveQueue.this.tableModel.getRow(index));
                    }
                });
                MoveQueue.this.tableModel.invokeLater(future);
                try {
                    final Tuple2<Boolean, ListSQLLine> line = future.get();
                    final boolean after = line.get0();
                    final ArrayList l = new ArrayList(rows);
                    Collections.sort(l, after ? Collections.reverseOrder(OrderComparator.INSTANCE) : OrderComparator.INSTANCE);
                    SQLUtils.executeAtomic(MoveQueue.this.tableModel.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws Exception {
                            MoveQueue.this.moveQuick(l, after, ((ListSQLLine)line.get1()).getRow().asRow());
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                }
            }
        });
    }

    final void moveQuick(List<? extends SQLRowAccessor> srcRows, boolean after, SQLRow destRow) throws SQLException {
        int rowCount = srcRows.size();
        if (rowCount < 5 && rowCount < this.tableModel.getRowCount() / 3) {
            SQLRowValues vals = new SQLRowValues(this.getTable());
            for (SQLRowAccessor sQLRowAccessor : srcRows) {
                assert (sQLRowAccessor.getTable() == vals.getTable());
                vals.setOrder(destRow, after).update(sQLRowAccessor.getID());
            }
        } else {
            MoveQueue.moveAtOnce(this.getTable(), srcRows, rowCount, after, destRow);
        }
    }

    private SQLTable getTable() {
        return this.tableModel.getTable();
    }

    /*
     * WARNING - void declaration
     */
    private static void moveAtOnce(SQLTable t, List<? extends SQLRowAccessor> srcRows, int rowCount, boolean after, SQLRow destRow) throws SQLException {
        boolean destRowReordered;
        BigDecimal inc;
        BigDecimal minDistance = t.getOrderULP().scaleByPowerOfTen(1);
        BigDecimal places = BigDecimal.valueOf(rowCount + 1);
        BigDecimal room = minDistance.multiply(places);
        BigDecimal destOrder = destRow.getOrder();
        SQLRow nextRow = destRow.getRow(true);
        if (nextRow == null) {
            inc = ReOrder.DISTANCE;
            destRowReordered = false;
        } else {
            BigDecimal nextOrder = nextRow.getOrder();
            assert (nextOrder.compareTo(destOrder) > 0);
            BigDecimal diff = nextOrder.subtract(destOrder);
            if (diff.compareTo(room) < 0) {
                int n = 100;
                int tableRowCount = t.getRowCount();
                boolean reordered = false;
                while (!reordered) {
                    void var14_15;
                    reordered = ReOrder.create(t, destOrder, !after, (int)var14_15, destOrder.add(room)).exec();
                    if (!reordered && var14_15 > tableRowCount) {
                        throw new IllegalStateException("Unable to reorder " + (int)var14_15 + " rows in " + t);
                    }
                    var14_15 *= 10;
                }
                inc = minDistance;
                destRowReordered = true;
            } else {
                inc = DecimalUtils.round(diff.divide(places, DecimalUtils.HIGH_PRECISION), t.getOrderDecimalDigits(), RoundingMode.DOWN);
                destRowReordered = false;
            }
        }
        assert (inc.compareTo(minDistance) >= 0);
        BigDecimal newOrder = destOrder;
        if (after) {
            newOrder = newOrder.add(inc);
        }
        ArrayList<List<String>> newOrdersAndIDs = new ArrayList<List<String>>(rowCount);
        Collections.sort(srcRows, OrderComparator.INSTANCE);
        for (SQLRowAccessor sQLRowAccessor : srcRows) {
            newOrdersAndIDs.add(Arrays.asList(sQLRowAccessor.getIDNumber().toString(), newOrder.toPlainString()));
            newOrder = newOrder.add(inc);
        }
        if (!after && !destRowReordered) {
            UpdateBuilder updateBuilder = new UpdateBuilder(t);
            updateBuilder.setObject(t.getOrderField(), (Object)newOrder);
            updateBuilder.setWhere(destRow.getWhere());
            t.getDBSystemRoot().getDataSource().execute(updateBuilder.asString());
        }
        SQLSyntax sQLSyntax = SQLSyntax.get(t);
        UpdateBuilder update = new UpdateBuilder(t);
        String constantTableAlias = "newOrdersAndIDs";
        update.addVirtualJoin(sQLSyntax.getConstantTable(newOrdersAndIDs, "newOrdersAndIDs", Arrays.asList("ID", "newOrder")), "newOrdersAndIDs", true, "ID", t.getKey().getName());
        update.setFromVirtualJoinField(t.getOrderField().getName(), "newOrdersAndIDs", "newOrder");
        t.getDBSystemRoot().getDataSource().execute(update.asString());
        t.fireTableModified(-1, Collections.singletonList(t.getOrderField().getName()));
    }
}

