/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.utils.CollectionUtils;

public final class ListSQLLine
implements Comparable<ListSQLLine> {
    private final SQLTableModelLinesSource src;
    private final SQLRowValues row;
    private final int id;
    private final List<Object> list;
    private int loadedCol;
    private final List<Object> pubList;

    public static final int indexFromID(List<ListSQLLine> l, int id) {
        int foundIndex = -1;
        int size = l.size();
        int i = 0;
        while (i < size) {
            int currentID = l.get(i).getID();
            if (currentID == id) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        return foundIndex;
    }

    public ListSQLLine(SQLTableModelLinesSource src, SQLRowValues row, int id) {
        this.src = src;
        this.row = row;
        this.id = id;
        this.list = new ArrayList<Object>();
        this.pubList = Collections.unmodifiableList(this.list);
        this.loadedCol = 0;
    }

    private synchronized void loadCache(int columnCount) {
        if (this.loadedCol >= columnCount) {
            return;
        }
        try {
            List<SQLTableModelColumn> allCols = this.src.getParent().getAllColumns();
            int i = this.loadedCol;
            while (i < columnCount) {
                this.list.add(allCols.get(i).show(this.row));
                ++i;
            }
            this.loadedCol = columnCount;
        }
        catch (RuntimeException e) {
            this.list.clear();
            this.loadedCol = 0;
            throw e;
        }
    }

    public final SQLTableModelLinesSource getSrc() {
        return this.src;
    }

    public final SQLRowValues getRow() {
        return this.row;
    }

    @Override
    public int compareTo(ListSQLLine o) {
        if (this.src != o.src) {
            throw new IllegalArgumentException(this.src + " != " + o.src);
        }
        return this.src.compare(this, o);
    }

    public int getID() {
        return this.id;
    }

    public synchronized List<Object> getList(int columnCount) {
        this.loadCache(columnCount);
        return this.pubList;
    }

    public final void setValueAt(Object obj, int colIndex) {
        this.src.getParent().getColumn(colIndex).put(this, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateValueAt(Set<Integer> colIndexes) {
        if (colIndexes.size() == 0) {
            return;
        }
        int max = Collections.max(colIndexes);
        ListSQLLine listSQLLine = this;
        synchronized (listSQLLine) {
            int alreadyLoaded = this.loadedCol;
            this.loadCache(max);
            for (int colIndex : colIndexes) {
                if (colIndex >= alreadyLoaded) continue;
                this.list.set(colIndex, this.src.getParent().getColumn(colIndex).show(this.getRow()));
            }
        }
        this.src.fireLineChanged(this.getID(), this, colIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ListSQLLine listSQLLine = this;
        synchronized (listSQLLine) {
            this.list.clear();
            this.loadedCol = 0;
        }
        this.src.fireLineChanged(this.getID(), this, null);
    }

    void loadAt(int id, SQLRowValues vals, Path p) {
        Set<Integer> indexes;
        String lastReferentField = SearchQueue.getLastReferentField(p);
        Set<Integer> set = indexes = lastReferentField == null ? this.pathToIndex(p, vals.getFields()) : null;
        if (lastReferentField == null) {
            for (SQLRowValues v : this.getRow().followPath(p, SQLRowValues.CreateMode.CREATE_NONE, false)) {
                v.load(vals.deepCopy(), null);
            }
        } else {
            SQLField lastField = p.getStep(-1).getSingleField();
            Collection<SQLRowValues> previous = p.length() > 1 && p.getStep(-2).reverse().equals(p.getStep(-1)) ? this.getRow().followPath(p.minusLast(2), SQLRowValues.CreateMode.CREATE_NONE, false) : null;
            Collection<SQLRowValues> targets = this.getRow().followPath(p.minusLast(), SQLRowValues.CreateMode.CREATE_NONE, false);
            for (SQLRowValues target : targets) {
                SQLRowValues toRemove = null;
                for (SQLRowValues toUpdate : target.getReferentRows(lastField)) {
                    if (previous != null && previous.contains(toUpdate) || toUpdate.getID() != id) continue;
                    if (toRemove != null) {
                        throw new IllegalStateException("Duplicate IDs " + id + " : " + System.identityHashCode(toRemove) + " and " + System.identityHashCode(toUpdate) + "\n" + this.getRow().printGraph());
                    }
                    toRemove = toUpdate;
                }
                if (toRemove != null) {
                    toRemove.remove(lastField.getName());
                }
                if (vals == null || vals.getLong(lastField.getName()) != target.getIDNumber().longValue()) continue;
                vals.deepCopy().put(lastField.getName(), target);
            }
        }
        if (indexes == null) {
            this.clearCache();
        } else {
            this.updateValueAt(indexes);
        }
    }

    private Set<Integer> pathToIndex(Path p, Collection<String> modifiedFields) {
        if (ListSQLLine.containsFK(p.getLast(), modifiedFields)) {
            return null;
        }
        HashSet<Integer> res = new HashSet<Integer>();
        Set<FieldPath> modifiedPaths = FieldPath.create(p, modifiedFields);
        List<SQLTableModelColumn> cols = this.src.getParent().getAllColumns();
        int i = 0;
        while (i < cols.size()) {
            SQLTableModelColumn col = cols.get(i);
            if (CollectionUtils.containsAny(col.getPaths(), modifiedPaths)) {
                res.add(i);
            }
            ++i;
        }
        return res;
    }

    private static boolean containsFK(SQLTable t, Collection<String> fields) {
        for (String f : fields) {
            if (!t.getForeignKeys().contains(t.getField(f))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.row;
    }
}

