/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.SwingThreadUtils;

public class IListeTransferHandler
extends TransferHandler {
    private static final DataFlavor FLAVOR = new DataFlavor(Data.class, "List of rows");

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        final IListe list = SwingThreadUtils.getAncestorOrSelf(IListe.class, c);
        if (!list.getModel().isEditable() || list.isSorted() || !list.getSource().getPrimaryTable().isOrdered()) {
            return null;
        }
        final List<SQLRowAccessor> selection = list.getSelectedRows();
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{FLAVOR};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return FLAVOR.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return new Data(list, selection);
            }
        };
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int action) {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        IListe targetList = SwingThreadUtils.getAncestorOrSelf(IListe.class, support.getComponent());
        return support.isDataFlavorSupported(FLAVOR) && targetList == this.getData(support).list;
    }

    private Data getData(TransferHandler.TransferSupport support) {
        try {
            return (Data)support.getTransferable().getTransferData(FLAVOR);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        Data data = this.getData(support);
        data.list.getModel().moveTo(data.selection, ((JTable.DropLocation)support.getDropLocation()).getRow());
        return true;
    }

    private static final class Data {
        private final IListe list;
        private final List<SQLRowAccessor> selection;

        private Data(IListe list, List<SQLRowAccessor> selection) {
            this.list = list;
            this.selection = new ArrayList<SQLRowAccessor>(selection);
        }
    }
}

