/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.utils.CollectionUtils;

public final class SQLCreateRoot {
    private final SQLSyntax syntax;
    private String name;
    private final List<String> clauses;
    private final List<SQLCreateTableBase<?>> tables;

    public SQLCreateRoot(SQLSyntax syntax, String name) {
        this.syntax = syntax;
        this.name = name;
        this.tables = new ArrayList();
        this.clauses = new ArrayList<String>();
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public final SQLCreateRoot addTable(SQLCreateTableBase<?> t) {
        this.tables.add(t);
        return this;
    }

    public final String asString(String r) {
        return this.asString(r, true, true);
    }

    public String asString(String r, boolean drop, boolean create) {
        return CollectionUtils.join(this.asStringList(r, drop, create, EnumSet.noneOf(ChangeTable.ConcatStep.class)), "\n");
    }

    public List<String> asStringList(String r, boolean drop, boolean create, EnumSet<ChangeTable.ConcatStep> boundaries) {
        List<List<String>> lists = this.asLists(r, drop, create, boundaries);
        ArrayList<String> res = new ArrayList<String>(lists.size());
        for (List<String> l : lists) {
            res.add(CollectionUtils.join(l, "\n"));
        }
        return res;
    }

    public List<List<String>> asLists(String r, boolean drop, boolean create, EnumSet<ChangeTable.ConcatStep> boundaries) {
        String initRoot;
        String rootName = r == null ? this.getName() : r;
        ArrayList<String> genClauses = new ArrayList<String>(this.clauses);
        if (create) {
            genClauses.add(0, this.getSyntax().getCreateRoot(rootName));
        }
        if (drop) {
            genClauses.add(0, this.getSyntax().getDropRoot(rootName));
        }
        if ((initRoot = this.getSyntax().getInitRoot(rootName)).trim().length() > 0) {
            genClauses.add(initRoot);
        }
        ArrayList<List<String>> res = new ArrayList<List<String>>(boundaries.size() + 2);
        res.add(genClauses);
        res.addAll(ChangeTable.cat(this.tables, rootName, boundaries));
        assert (res.size() == boundaries.size() + 2);
        return res;
    }

    public final String toString() {
        return this.asString(null);
    }

    public final String getName() {
        return this.name;
    }
}

