/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class ChangeTable<T extends ChangeTable<T>> {
    public static final Set<ClauseType> ORDERED_TYPES;
    private String rootName;
    private String name;
    private final SQLSyntax syntax;
    private final List<FCSpec> fks;
    private final ListMap<ClauseType, String> clauses;
    private final ListMap<ClauseType, DeferredClause> inClauses;
    private final ListMap<ClauseType, DeferredClause> outClauses;

    static {
        LinkedHashSet<ClauseType> tmp = new LinkedHashSet<ClauseType>(ClauseType.values().length);
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            tmp.addAll(step.getTypes());
            ++n2;
        }
        assert (tmp.equals(EnumSet.allOf(ClauseType.class))) : "ConcatStep is missing some types : " + tmp;
        ORDERED_TYPES = Collections.unmodifiableSet(tmp);
    }

    public static List<List<String>> cat(Collection<? extends ChangeTable<?>> cts, String r, EnumSet<ConcatStep> boundaries) {
        if (r == null) {
            throw new NullPointerException("r is null");
        }
        return ChangeTable.cat(cts, new ChangeRootNameTransformer(r), boundaries);
    }

    public static List<List<String>> cat(Collection<? extends ChangeTable<?>> cts, NameTransformer transf, EnumSet<ConcatStep> boundaries) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        ArrayList<String> current = null;
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            if (current == null || boundaries.contains((Object)step)) {
                current = new ArrayList<String>();
                res.add(current);
            }
            for (ChangeTable<?> ct : cts) {
                String asString = ct.asString(transf, step);
                if (asString == null || asString.length() <= 0) continue;
                current.add(asString);
            }
            ++n2;
        }
        assert (res.size() == boundaries.size() + 1);
        return res;
    }

    public ChangeTable(SQLSyntax syntax, String rootName, String name) {
        this.syntax = syntax;
        this.rootName = rootName;
        this.name = name;
        this.fks = new ArrayList<FCSpec>();
        this.clauses = new ListMap();
        this.inClauses = new ListMap();
        this.outClauses = new ListMap();
        if (this.getClass() != ReflectUtils.getTypeArguments(this, ChangeTable.class).get(0)) {
            throw new IllegalStateException("illegal subclass: " + this.getClass());
        }
    }

    protected final T thisAsT() {
        return (T)this;
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public void reset() {
        this.fks.clear();
        this.clauses.clear();
        this.inClauses.clear();
        this.outClauses.clear();
    }

    public boolean isEmpty() {
        return this.fks.isEmpty() && this.clauses.isEmpty() && this.inClauses.isEmpty() && this.outClauses.isEmpty();
    }

    protected T mutateTo(ChangeTable<?> ct) {
        if (this.getSyntax() != ct.getSyntax()) {
            throw new IllegalArgumentException("not same syntax: " + this.getSyntax() + " != " + ct.getSyntax());
        }
        this.setName(ct.getName());
        for (Map.Entry e : ct.clauses.entrySet()) {
            for (String s : (Collection)e.getValue()) {
                this.addClause(s, (ClauseType)((Object)e.getKey()));
            }
        }
        for (DeferredClause c : ct.inClauses.allValues()) {
            this.addClause(c);
        }
        for (DeferredClause c : ct.outClauses.allValues()) {
            this.addOutsideClause(c);
        }
        for (FCSpec fk : ct.fks) {
            this.addForeignConstraint(fk, false);
        }
        return this.thisAsT();
    }

    public final T addVarCharColumn(String name, int count) {
        return this.addColumn(name, "varchar(" + count + ") default '' NOT NULL");
    }

    public abstract T addColumn(String var1, String var2);

    public final T addColumn(SQLField f) {
        return this.addColumn(f.getName(), f);
    }

    public final T addColumn(String name, SQLField f) {
        return this.addColumn(name, this.getSyntax().getFieldDecl(f));
    }

    public final T addForeignConstraint(Link l, boolean createIndex) {
        return this.addForeignConstraint(FCSpec.createFromLink(l), createIndex);
    }

    public final T addForeignConstraint(final FCSpec fkSpec, boolean createIndex) {
        this.fks.add(fkSpec);
        if (createIndex) {
            this.addOutsideClause(new OutsideClause(){

                @Override
                public ClauseType getType() {
                    return ClauseType.ADD_INDEX;
                }

                @Override
                public String asString(SQLName tableName) {
                    return ChangeTable.this.getSyntax().getCreateIndex("_fki", tableName, fkSpec.getCols());
                }
            });
        }
        return this.thisAsT();
    }

    public final List<FCSpec> getForeignConstraints() {
        return Collections.unmodifiableList(this.fks);
    }

    public T addUniqueConstraint(final String name, final List<String> cols) {
        return this.addClause(new DeferredClause(){

            @Override
            public String asString(ChangeTable<?> ct, SQLName tableName) {
                String constrName = SQLSyntax.getSchemaUniqueName(tableName.getName(), name);
                return String.valueOf(ct.getConstraintPrefix()) + "CONSTRAINT " + SQLBase.quoteIdentifier(constrName) + " UNIQUE (" + SQLSyntax.quoteIdentifiers(cols) + ")";
            }

            @Override
            public ClauseType getType() {
                return ClauseType.ADD_CONSTRAINT;
            }
        });
    }

    protected abstract String getConstraintPrefix();

    public final T addClause(String s, ClauseType type) {
        this.clauses.add(type, s);
        return this.thisAsT();
    }

    protected final List<String> getClauses(SQLName tableName, ClauseType type) {
        if (this.inClauses.size() == 0) {
            return (List)this.clauses.getNonNull(type);
        }
        ArrayList<String> res = new ArrayList<String>((Collection<String>)this.clauses.getNonNull(type));
        for (DeferredClause c : (List)this.inClauses.getNonNull(type)) {
            res.add(c.asString(this, tableName));
        }
        return res;
    }

    protected final List<String> getClauses(SQLName tableName, Collection<ClauseType> types) {
        ArrayList<String> res = new ArrayList<String>();
        for (ClauseType type : types) {
            res.addAll(this.getClauses(tableName, type));
        }
        return res;
    }

    public final T addClause(DeferredClause s) {
        this.inClauses.add(s.getType(), s);
        return this.thisAsT();
    }

    public final T addOutsideClause(DeferredClause s) {
        if (s != null) {
            this.outClauses.add(s.getType(), s);
        }
        return this.thisAsT();
    }

    protected final void outClausesAsString(StringBuffer res, final SQLName tableName, Set<ClauseType> types) {
        ArrayList<DeferredClause> clauses = new ArrayList<DeferredClause>();
        for (ClauseType type : types) {
            clauses.addAll((Collection<DeferredClause>)this.outClauses.getNonNull(type));
        }
        this.modifyOutClauses(clauses);
        if (clauses.size() > 0) {
            res.append("\n\n");
            res.append(CollectionUtils.join(clauses, "\n", new ITransformer<DeferredClause, String>(){

                public String transformChecked(DeferredClause input) {
                    return input.asString(ChangeTable.this, tableName);
                }
            }));
        }
    }

    protected void modifyOutClauses(List<DeferredClause> clauses) {
    }

    public final String asString() {
        return this.asString(NameTransformer.NOP);
    }

    public final String asString(String rootName) {
        return this.asString(new ChangeRootNameTransformer(rootName));
    }

    public abstract String asString(NameTransformer var1);

    protected abstract String asString(NameTransformer var1, ConcatStep var2);

    protected final List<String> getForeignConstraints(NameTransformer transf) {
        ArrayList<String> res = new ArrayList<String>(this.fks.size());
        for (FCSpec fk : this.fks) {
            SQLName relRefTable = fk.getRefTable();
            SQLName refTable = transf.transformLinkDestTableName(this.getRootName(), this.getName(), relRefTable);
            res.add(String.valueOf(this.getConstraintPrefix()) + this.getSyntax().getFK(String.valueOf(this.name) + "_", fk.getCols(), refTable, fk.getRefCols(), fk.getUpdateRule(), fk.getDeleteRule()));
        }
        return res;
    }

    public String toString() {
        return this.asString();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getRootName() {
        return this.rootName;
    }

    public static class ChangeRootNameTransformer
    extends NameTransformer {
        private final String r;

        public ChangeRootNameTransformer(String r) {
            this.r = r;
        }

        @Override
        public SQLName transformTableName(SQLName tableName) {
            return new SQLName(this.r, tableName.getName());
        }

        @Override
        public SQLName transformLinkDestTableName(String rootName, String tableName, SQLName linkDest) {
            return linkDest.getItemCount() == 1 ? this.transformTableName(new SQLName(rootName, linkDest.getName())) : linkDest;
        }
    }

    public static enum ClauseType {
        ADD_COL,
        ADD_CONSTRAINT,
        ADD_INDEX,
        DROP_COL,
        DROP_CONSTRAINT,
        DROP_INDEX,
        ALTER_COL,
        OTHER;

    }

    public static enum ConcatStep {
        DROP_FOREIGN(ClauseType.DROP_CONSTRAINT),
        DROP_INDEX(ClauseType.DROP_INDEX),
        ALTER_TABLE(ClauseType.ADD_COL, ClauseType.DROP_COL, ClauseType.ALTER_COL, ClauseType.OTHER),
        ADD_INDEX(ClauseType.ADD_INDEX),
        ADD_FOREIGN(ClauseType.ADD_CONSTRAINT);

        private final Set<ClauseType> types = new HashSet<ClauseType>();

        private ConcatStep(ClauseType ... types) {
            ClauseType[] clauseTypeArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                ClauseType t = clauseTypeArray[n3];
                this.types.add(t);
                ++n3;
            }
        }

        public final Set<ClauseType> getTypes() {
            return this.types;
        }
    }

    public static interface DeferredClause {
        public String asString(ChangeTable<?> var1, SQLName var2);

        public ClauseType getType();
    }

    public static final class FCSpec {
        private final List<String> cols;
        private final SQLName refTable;
        private final List<String> refCols;
        private final Link.Rule updateRule;
        private final Link.Rule deleteRule;

        public static FCSpec createFromLink(Link l) {
            return FCSpec.createFromLink(l, (SQLTable)l.getTarget());
        }

        public static FCSpec createFromLink(Link l, SQLTable newDest) {
            if (newDest != l.getTarget()) {
                List<SQLField> ffs = l.getFields();
                Set<SQLField> pks = newDest.getPrimaryKeys();
                if (ffs.size() != pks.size()) {
                    throw new IllegalArgumentException("Size mismatch : " + ffs + " " + pks);
                }
                int i = 0;
                for (SQLField pk : pks) {
                    if (!ffs.get(i).getType().equals(pk.getType())) {
                        throw new IllegalArgumentException("Type mismatch " + ffs.get(i) + " " + pk);
                    }
                    ++i;
                }
            }
            return new FCSpec(l.getCols(), newDest.getContextualSQLName((SQLIdentifier)l.getSource()), newDest.getPKsNames(), l.getUpdateRule(), l.getDeleteRule());
        }

        public FCSpec(List<String> cols, SQLName refTable, List<String> refCols, Link.Rule updateRule, Link.Rule deleteRule) {
            if (refTable.getItemCount() == 0) {
                throw new IllegalArgumentException(refTable + " is empty.");
            }
            this.cols = Collections.unmodifiableList(new ArrayList<String>(cols));
            this.refTable = refTable;
            this.refCols = Collections.unmodifiableList(new ArrayList<String>(refCols));
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        public final SQLName getRefTable() {
            return this.refTable;
        }

        public final List<String> getRefCols() {
            return this.refCols;
        }

        public final Link.Rule getUpdateRule() {
            return this.updateRule;
        }

        public final Link.Rule getDeleteRule() {
            return this.deleteRule;
        }
    }

    public static class NameTransformer {
        public static final NameTransformer NOP = new NameTransformer();

        public SQLName transformTableName(SQLName tableName) {
            return tableName;
        }

        public SQLName transformLinkDestTableName(String rootName, String tableName, SQLName linkDest) {
            return this.transformTableName(linkDest.getItemCount() == 1 ? new SQLName(rootName, linkDest.getName()) : linkDest);
        }
    }

    public static abstract class OutsideClause
    implements DeferredClause {
        public abstract String asString(SQLName var1);

        @Override
        public String asString(ChangeTable<?> ct, SQLName tableName) {
            return this.asString(tableName);
        }
    }
}

