/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.users.User;

public class UserManager {
    private static UserManager instance;
    private final SQLTable t;
    private final Map<Integer, User> byID = new LinkedHashMap<Integer, User>();
    private boolean dirty;
    private User currentUser = null;

    public static final synchronized UserManager getInstance() {
        SQLTable table;
        if (instance == null && Configuration.getInstance() != null && (table = Configuration.getInstance().getRoot().findTable("USER_COMMON")) != null) {
            instance = new UserManager(table);
        }
        return instance;
    }

    public static final User getUser() {
        UserManager mngr = UserManager.getInstance();
        return mngr == null ? null : mngr.getCurrentUser();
    }

    public static final int getUserID() {
        User user = UserManager.getUser();
        return user == null ? -1 : user.getId();
    }

    private UserManager(SQLTable t) {
        this.t = t;
        this.t.addTableModifiedListener(new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                UserManager.this.dirty = true;
            }
        });
        this.fillUsers();
    }

    private synchronized void fillUsers() {
        this.byID.clear();
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(new SQLRowValues(this.t).setAllToNull());
        fetcher.setOrdered(true);
        for (SQLRowValues v : fetcher.fetch()) {
            User u = new User(v.getID(), v.getString("NOM"));
            u.setFirstName(v.getString("PRENOM"));
            u.setNickName(v.getString("SURNOM"));
            this.byID.put(v.getID(), u);
        }
        this.dirty = false;
    }

    public final SQLTable getTable() {
        return this.t;
    }

    private final Map<Integer, User> getUsers() {
        if (this.dirty) {
            this.fillUsers();
        }
        return this.byID;
    }

    public final User getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(int id) {
        this.currentUser = this.getUser(id);
    }

    public synchronized List<User> getAllUser() {
        return new ArrayList<User>(this.getUsers().values());
    }

    public synchronized User getUser(Integer v) {
        if (this.getUsers().containsKey(v)) {
            return this.getUsers().get(v);
        }
        throw new IllegalStateException("Bad user! " + v);
    }
}

