/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.AbstractPath;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;

public class PathBuilder
extends AbstractPath<PathBuilder> {
    private final List<SQLTable> tables = new ArrayList<SQLTable>();
    private final List<Step> fields = new ArrayList<Step>();
    private final List<SQLField> singleFields = new ArrayList<SQLField>();

    public PathBuilder(SQLTable start) {
        this.tables.add(start);
    }

    public final Path build() {
        return Path.create(this.tables, this.fields, this.singleFields);
    }

    @Override
    public List<SQLTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    protected final PathBuilder _append(Path p) {
        this.fields.addAll(p.getSteps());
        this.singleFields.addAll(p.getSingleSteps());
        this.tables.addAll(p.getTables().subList(1, p.getTables().size()));
        return this;
    }

    @Override
    final PathBuilder add(Step step) {
        assert (step.getFrom() == this.getLast()) : "broken path";
        this.fields.add(step);
        this.singleFields.add(step.getSingleField());
        this.tables.add(step.getTo());
        return this;
    }

    @Override
    public final List<Step> getSteps() {
        return Collections.unmodifiableList(this.fields);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.tables + "\n\tLinks:" + this.fields;
    }
}

