/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.AbstractPath;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;

public final class Path
extends AbstractPath<Path> {
    private static final Map<SQLTable, Path> EMPTY_PATHS = new LinkedHashMap<SQLTable, Path>(8, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<SQLTable, Path> eldest) {
            return this.size() > 48;
        }
    };
    private final List<SQLTable> tables;
    private final List<Step> fields;
    private final List<SQLField> singleFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path get(SQLTable first) {
        Map<SQLTable, Path> map = EMPTY_PATHS;
        synchronized (map) {
            Path res = EMPTY_PATHS.get(first);
            if (res == null) {
                res = new Path(first);
                EMPTY_PATHS.put(first, res);
            }
            return res;
        }
    }

    public static Path create(SQLTable first, List<Link> links) {
        if (links == null) {
            return null;
        }
        PathBuilder builder = new PathBuilder(first);
        for (Link l : links) {
            builder.add(l);
        }
        return builder.build();
    }

    private static final <T> List<T> copy(List<T> l) {
        return Collections.unmodifiableList(new ArrayList<T>(l));
    }

    static Path create(List<SQLTable> tables, List<Step> steps, List<SQLField> singleFields) {
        return new Path(Path.copy(tables), Path.copy(steps), Path.copy(singleFields));
    }

    public Path(SQLTable start) {
        this.tables = Collections.singletonList(start);
        this.fields = Collections.emptyList();
        this.singleFields = Collections.emptyList();
    }

    public Path(Step step) {
        this.tables = Arrays.asList(step.getFrom(), step.getTo());
        this.fields = Collections.singletonList(step);
        this.singleFields = Collections.singletonList(step.getSingleField());
    }

    private Path(List<SQLTable> tables, List<Step> steps, List<SQLField> singleFields) {
        this.tables = tables;
        this.fields = steps;
        this.singleFields = singleFields;
    }

    public final Path reverse() {
        int stepsCount = this.fields.size();
        if (stepsCount == 0) {
            return this;
        }
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>(stepsCount + 1);
        ArrayList<Step> steps = new ArrayList<Step>(stepsCount);
        ArrayList<SQLField> singleFields = new ArrayList<SQLField>(stepsCount);
        int i = stepsCount - 1;
        while (i >= 0) {
            Step reversedStep = this.fields.get(i).reverse();
            tables.add(reversedStep.getFrom());
            steps.add(reversedStep);
            singleFields.add(reversedStep.getSingleField());
            --i;
        }
        tables.add(this.getFirst());
        return new Path(Collections.unmodifiableList(tables), Collections.unmodifiableList(steps), Collections.unmodifiableList(singleFields));
    }

    public Path minusFirst() {
        return this.subPath(1, this.length());
    }

    public Path minusLast() {
        return this.minusLast(1);
    }

    public Path minusLast(int count) {
        return this.subPath(0, this.length() - count);
    }

    public Path subPath(int fromIndex, int toIndex) {
        fromIndex = CollectionUtils.getValidIndex(this.fields, fromIndex);
        toIndex = CollectionUtils.getValidIndex(this.fields, toIndex);
        if (fromIndex == 0 && toIndex == this.length()) {
            return this;
        }
        return new Path(this.tables.subList(fromIndex, toIndex + 1), this.fields.subList(fromIndex, toIndex), this.singleFields.subList(fromIndex, toIndex));
    }

    @Override
    public List<SQLTable> getTables() {
        return this.tables;
    }

    @Override
    protected final Path _append(Path p) {
        int thisLength = this.length();
        int oLength = p.length();
        if (thisLength == 0) {
            return p;
        }
        if (oLength == 0) {
            return this;
        }
        int stepsCount = thisLength + oLength;
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>(stepsCount + 1);
        ArrayList<Step> steps = new ArrayList<Step>(stepsCount);
        ArrayList<SQLField> singleFields = new ArrayList<SQLField>(stepsCount);
        tables.addAll(this.tables.subList(0, thisLength));
        tables.addAll(p.tables);
        steps.addAll(this.fields);
        steps.addAll(p.fields);
        singleFields.addAll(this.singleFields);
        singleFields.addAll(p.singleFields);
        return new Path(Collections.unmodifiableList(tables), Collections.unmodifiableList(steps), Collections.unmodifiableList(singleFields));
    }

    @Override
    final Path add(Step step) {
        return (Path)this.append(new Path(step));
    }

    @Override
    public final List<Step> getSteps() {
        return this.fields;
    }

    public final Step getStep(int i) {
        return this.fields.get(CollectionUtils.getValidIndex(this.fields, i, true));
    }

    public SQLField getSingleStep(int i) {
        return this.singleFields.get(i);
    }

    public final List<SQLField> getSingleSteps() {
        return this.singleFields;
    }

    public boolean isSingleLink() {
        for (SQLField step : this.singleFields) {
            if (step != null) continue;
            return false;
        }
        return true;
    }

    public final Boolean isBackwards(int i) {
        Boolean foreign = this.getStep(i).isForeign();
        return foreign == null ? null : Boolean.valueOf(foreign == false);
    }

    public final Link.Direction getDirection() {
        HashSet<Link.Direction> directions = new HashSet<Link.Direction>(this.fields.size());
        for (Step s : this.fields) {
            directions.add(s.getDirection());
        }
        return (Link.Direction)((Object)CollectionUtils.getSole(directions));
    }

    public final boolean isDirection(Link.Direction dir) {
        if (dir == null) {
            throw new NullPointerException("Null direction");
        }
        return this.length() == 0 || this.getDirection() == dir;
    }

    public String toString() {
        return "Path\n\tTables: " + this.tables + "\n\tLinks:" + this.fields;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path o = (Path)obj;
            return this.getFirst().equals(o.getFirst()) && this.fields.equals(o.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public boolean startsWith(Path other) {
        return this.length() >= other.length() && this.subPath(0, other.length()).equals(other);
    }
}

