/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.xml.JDOMUtils;
import org.openconcerto.xml.XMLCodecUtils;

public final class Trigger {
    private final SQLTable t;
    private final String name;
    private final Map<String, Object> m;
    private String xml = null;

    public static Trigger fromXML(SQLTable t, Element elem) {
        return new Trigger(t, elem.getAttributeValue("name"), (Map)XMLCodecUtils.decode1((Element)elem.getChildren().get(0)));
    }

    private Trigger(SQLTable t, String name, Map<String, Object> row) {
        this.t = t;
        this.name = name;
        this.m = row;
    }

    Trigger(SQLTable t, Map<String, Object> row) {
        this.t = t;
        this.m = new HashMap<String, Object>(row);
        this.name = (String)this.m.remove("TRIGGER_NAME");
    }

    Trigger(SQLTable t, Trigger trigger) {
        this.t = t;
        this.m = trigger.m;
        this.name = trigger.name;
    }

    public final String getName() {
        return this.name;
    }

    public synchronized String toXML() {
        if (this.xml == null) {
            this.xml = "<trigger name=\"" + JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()) + "\">" + XMLCodecUtils.encodeSimple(this.m) + "</trigger>";
        }
        return this.xml;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Trigger) {
            Trigger o = (Trigger)obj;
            return this.getName().equals(o.getName()) && this.m.equals(o.m);
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.m.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName();
    }
}

