/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLImmutableRowValues;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.i18n.Grammar;

public class SQLInjector {
    private final SQLTable tableSrc;
    private final SQLTable tableDest;
    private final ArrayList<SQLField> from = new ArrayList();
    private final ArrayList<SQLField> to = new ArrayList();
    private final Map<SQLField, Object> values = new HashMap<SQLField, Object>();
    private static final Map<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>> allRegisteredInjectors = new HashMap<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>>();
    private boolean storeTransfer;
    private static Map<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>> injectors = new HashMap<DBRoot, Map<SQLTable, Map<SQLTable, SQLInjector>>>();

    public SQLInjector(DBRoot r, String src, String dest, boolean storeTransfer) {
        this(r.findTable(src), r.findTable(dest), storeTransfer);
    }

    public SQLInjector(SQLTable src, SQLTable dest, boolean storeTransfer) {
        Map<SQLTable, SQLInjector> srcs;
        this.tableDest = dest;
        this.tableSrc = src;
        this.storeTransfer = storeTransfer;
        DBRoot dbRoot = src.getDBRoot();
        Map<SQLTable, Map<SQLTable, SQLInjector>> inj = allRegisteredInjectors.get(dbRoot);
        if (inj == null) {
            inj = new HashMap<SQLTable, Map<SQLTable, SQLInjector>>();
            allRegisteredInjectors.put(dbRoot, inj);
        }
        if ((srcs = inj.get(src)) == null) {
            srcs = new HashMap<SQLTable, SQLInjector>();
            inj.put(src, srcs);
        }
        srcs.put(dest, this);
        if (storeTransfer) {
            inj = injectors.get(dbRoot);
            if (inj == null) {
                inj = new HashMap<SQLTable, Map<SQLTable, SQLInjector>>();
                injectors.put(dbRoot, inj);
            }
            if ((srcs = inj.get(src)) == null) {
                srcs = new HashMap<SQLTable, SQLInjector>();
                inj.put(src, srcs);
            }
            srcs.put(dest, this);
        }
    }

    public synchronized SQLRowValues createRowValuesFrom(int idSrc) {
        ArrayList<SQLImmutableRowValues> srcRows = new ArrayList<SQLImmutableRowValues>(1);
        srcRows.add(new SQLImmutableRowValues(this.getSource().getRow(idSrc).asRowValues()));
        return this.createRowValuesFrom(srcRows);
    }

    public synchronized SQLRowValues createRowValuesFrom(SQLRow srcRow) {
        SQLRowValues rowVals = new SQLRowValues(this.getDestination());
        if (!srcRow.getTable().equals(this.getSource())) {
            throw new IllegalArgumentException("Row not from source table : " + srcRow);
        }
        this.merge(srcRow, rowVals);
        return rowVals;
    }

    public synchronized SQLRowValues createRowValuesFrom(List<? extends SQLRowAccessor> srcRows) {
        SQLRowValues rowVals = new SQLRowValues(this.getDestination());
        for (SQLRowAccessor sQLRowAccessor : srcRows) {
            if (!sQLRowAccessor.getTable().equals(this.getSource())) {
                throw new IllegalArgumentException("Row not from source table : " + sQLRowAccessor);
            }
            this.merge(sQLRowAccessor, rowVals);
        }
        return rowVals;
    }

    public void commitTransfert(List<? extends SQLRowAccessor> srcRows, int destId) throws SQLException {
        if (this.storeTransfer) {
            System.err.println("SQLInjector.commitTransfert() : transfert from " + this.getSource().getName() + " to " + this.getDestination().getName());
            SQLTable tableTransfert = this.getSource().getDBRoot().getTable(this.getTableTranferName());
            if (tableTransfert == null) {
                throw new IllegalStateException("No table transfer for " + this.getSource().getName());
            }
            for (SQLRowAccessor sQLRowAccessor : srcRows) {
                SQLRowValues rowTransfer = new SQLRowValues(tableTransfert);
                Set<SQLField> foreignKeysSrc = tableTransfert.getForeignKeys(this.getSource());
                Set<SQLField> foreignKeysDest = tableTransfert.getForeignKeys(this.getDestination());
                if (foreignKeysSrc.isEmpty()) {
                    throw new IllegalStateException("No foreign (src) to " + this.getSource().getName() + " in " + tableTransfert.getName());
                }
                if (foreignKeysDest.isEmpty()) {
                    throw new IllegalStateException("No foreign (dest) to " + this.getDestination().getName() + " in " + tableTransfert.getName());
                }
                rowTransfer.put(foreignKeysSrc.iterator().next().getName(), sQLRowAccessor.getIDNumber());
                rowTransfer.put(foreignKeysDest.iterator().next().getName(), destId);
                rowTransfer.commit();
            }
        }
    }

    private String getTableTranferName() {
        return "TR_" + this.getSource().getName();
    }

    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        for (SQLField field : this.values.keySet()) {
            rowVals.put(field.getName(), this.values.get(field));
        }
        SQLSystem dbSystem = srcRow.getTable().getDBSystemRoot().getServer().getSQLSystem();
        int size = this.getFrom().size();
        int i = 0;
        while (i < size) {
            SQLField sqlFieldFrom = this.getFrom().get(i);
            SQLField sqlFieldTo = this.getTo().get(i);
            Object o = srcRow.getObject(sqlFieldFrom.getName());
            if (dbSystem == SQLSystem.H2 && sqlFieldFrom.getType().getJavaType() == Long.class && sqlFieldTo.getType().getJavaType() == Integer.class) {
                this.merge(sqlFieldTo, ((Long)o).intValue(), rowVals);
            } else {
                this.merge(sqlFieldTo, o, rowVals);
            }
            ++i;
        }
    }

    protected void merge(SQLField field, Object value, SQLRowValues rowVals) {
        rowVals.put(field.getName(), value);
    }

    protected void transfertReference(SQLRowAccessor srcRow, SQLRowValues rowVals, String from, String to) {
        String label = rowVals.getString(to);
        if (label != null && label.trim().length() > 0) {
            rowVals.put(to, String.valueOf(label) + ", " + srcRow.getString(from));
        } else {
            rowVals.put(to, srcRow.getString(from));
        }
    }

    protected void transfertNumberReference(SQLRowAccessor srcRow, SQLRowValues rowVals, SQLTable tableElementDestination, String refField) {
        SQLPreferences prefs = new SQLPreferences(srcRow.getTable().getDBRoot());
        if (prefs.getBoolean("TransfertRef", true)) {
            String label = rowVals.getString("NOM");
            if (label != null && label.trim().length() > 0) {
                rowVals.put("NOM", String.valueOf(label) + ", " + srcRow.getString("NUMERO"));
            } else {
                rowVals.put("NOM", srcRow.getString("NUMERO"));
            }
        } else if (prefs.getBoolean("TransfertMultiRef", false)) {
            SQLRowValues rowValsHeader = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableElementDestination));
            String elementName = StringUtils.firstUp(Configuration.getInstance().getDirectory().getElement(this.getSource()).getName().getVariant(Grammar.SINGULAR));
            rowValsHeader.put("NOM", String.valueOf(elementName) + " N\u00b0 " + srcRow.getString("NUMERO"));
            rowValsHeader.put(refField, rowVals);
        }
    }

    protected final synchronized void mapDefaultValues(SQLField fieldDest, Object defaultValue) {
        if (!fieldDest.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + fieldDest + " is not a field of table " + this.tableDest);
        }
        this.values.put(fieldDest, defaultValue);
    }

    protected final synchronized void map(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (index > 0) {
            this.to.set(index, to);
        } else {
            this.from.add(from);
            this.to.add(to);
        }
    }

    protected final synchronized void remove(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (this.to.get(index).getName().equalsIgnoreCase(to.getName())) {
            this.to.remove(to);
            this.from.remove(from);
        }
    }

    public synchronized void createDefaultMap() {
        for (SQLField field : this.tableSrc.getContentFields()) {
            if (!this.tableDest.contains(field.getName())) continue;
            this.map(field, this.tableDest.getField(field.getName()));
        }
    }

    public synchronized ArrayList<SQLField> getFrom() {
        return this.from;
    }

    public synchronized ArrayList<SQLField> getTo() {
        return this.to;
    }

    public static synchronized SQLInjector getInjector(SQLTable src, SQLTable dest) {
        SQLInjector injector = SQLInjector.getRegistrereddInjector(src, dest);
        if (injector == null) {
            injector = SQLInjector.createDefaultInjector(src, dest);
        }
        return injector;
    }

    public static synchronized SQLInjector getRegistrereddInjector(SQLTable src, SQLTable dest) {
        Map<SQLTable, Map<SQLTable, SQLInjector>> map = allRegisteredInjectors.get(src.getDBRoot());
        if (map == null) {
            return null;
        }
        Map<SQLTable, SQLInjector> m = map.get(src);
        if (m != null) {
            return m.get(dest);
        }
        return null;
    }

    private static synchronized SQLInjector createDefaultInjector(SQLTable src, SQLTable dest) {
        System.err.println("No SQLInjector defined for " + src + " , " + dest + ". SQLInjector created automatically.");
        SQLInjector injector = new SQLInjector(src, dest, false);
        injector.createDefaultMap();
        return injector;
    }

    public synchronized SQLTable getDestination() {
        return this.tableDest;
    }

    public synchronized SQLTable getSource() {
        return this.tableSrc;
    }
}

