/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.SetMap;

public class SQLFieldsSet {
    private static final SQLFieldsSet EMPTY = new SQLFieldsSet(SetMap.<SQLTable, SQLField>empty(), true);
    private final CollectionMap2Itf.SetMapItf<SQLTable, SQLField> tables;

    private static final CollectionMap2Itf.SetMapItf<SQLTable, SQLField> toSetMap(Collection<SQLField> fields) {
        CollectionMap2Itf.SetMapItf<SQLTable, SQLField> res = SQLFieldsSet.createMap();
        for (SQLField f : fields) {
            res.add(f.getTable(), f);
        }
        return res;
    }

    private static CollectionMap2Itf.SetMapItf<SQLTable, SQLField> createMap() {
        return new SetMap<SQLTable, SQLField>(){

            @Override
            public Set<SQLField> createCollection(Collection<? extends SQLField> v) {
                LinkedHashSet<SQLField> res = new LinkedHashSet<SQLField>(8);
                res.addAll(v);
                return res;
            }
        };
    }

    public SQLFieldsSet(Collection<SQLField> fields) {
        this(SQLFieldsSet.toSetMap(fields), false);
    }

    private SQLFieldsSet(CollectionMap2Itf.SetMapItf<SQLTable, SQLField> fields, boolean unmodif) {
        this.tables = unmodif ? fields : SetMap.unmodifiableMap(fields);
    }

    public final Set<SQLField> getFields(SQLTable table) {
        return (Set)this.tables.getNonNull(table);
    }

    public final Set<String> getFieldsNames(SQLTable table) {
        HashSet<String> res = new HashSet<String>();
        for (SQLField f : this.getFields(table)) {
            res.add(f.getName());
        }
        return res;
    }

    public final Set<SQLTable> getTables() {
        return this.tables.keySet();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.tables;
    }
}

