/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.xml.JDOMUtils;
import org.openconcerto.xml.XMLCodecUtils;

public class SQLField
extends SQLIdentifier
implements FieldRef,
IFieldPath {
    private static final Pattern SEQ_PATTERN = Pattern.compile("nextval\\('(.+)'.*\\)");
    private final String fullName;
    private SQLType type;
    private final Map<String, Object> metadata;
    private Object defaultValue;
    private Boolean nullable;
    private final Map<String, Object> infoSchemaCols;
    private String xml;

    static final SQLField create(SQLTable t, ResultSet rs) throws SQLException {
        Map<String, Object> map;
        SQLType type;
        String fieldName = rs.getString("COLUMN_NAME");
        int dataType = rs.getInt("DATA_TYPE");
        int size = rs.getInt("COLUMN_SIZE");
        try {
            Object decDig = rs.getObject("DECIMAL_DIGITS");
            Integer intDecDig = (Integer)(decDig == null || decDig instanceof Integer ? decDig : Integer.valueOf(((Number)decDig).intValue()));
            type = SQLType.get(t.getBase(), dataType, size, intDecDig, rs.getString("TYPE_NAME"));
        }
        catch (IllegalStateException e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "can't create " + t + " " + fieldName, e);
        }
        if (t.getServer().getSQLSystem() == SQLSystem.MSSQL) {
            map = SQLDataSource.ROW_PROC.toMap(rs, Collections.singleton("IS_AUTOINCREMENT"));
            map.put("IS_AUTOINCREMENT", rs.getString("IS_AUTOINCREMENT"));
        } else {
            map = SQLDataSource.ROW_PROC.toMap(rs);
        }
        return new SQLField(t, fieldName, type, map);
    }

    private static Boolean nullableStr2Obj(String isNullable) {
        Boolean res = "YES".equalsIgnoreCase(isNullable) ? Boolean.TRUE : ("NO".equalsIgnoreCase(isNullable) ? Boolean.FALSE : null);
        return res;
    }

    static SQLField create(SQLTable t, Element elementField) {
        String fieldName = elementField.getAttributeValue("name");
        SQLType type = SQLType.get(t.getBase(), elementField.getChild("type"));
        Map metadata = (Map)XMLCodecUtils.decode1(elementField.getChild("java"));
        Map infoSchema = (Map)XMLCodecUtils.decode1(elementField.getChild("infoSchema").getChild("java"));
        SQLField res = new SQLField(t, fieldName, type, metadata);
        res.setColsFromInfoSchema(infoSchema);
        return res;
    }

    SQLField(SQLTable table, String name, SQLType type, Map<String, Object> metadata) {
        super(table, name);
        this.type = type;
        this.metadata = metadata;
        Iterator<Map.Entry<String, Object>> iter = this.metadata.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> e = iter.next();
            if (e.getValue() != null) continue;
            iter.remove();
        }
        this.defaultValue = metadata.get("COLUMN_DEF");
        this.fullName = String.valueOf(this.getTable().getName()) + "." + this.getName();
        this.nullable = SQLField.nullableStr2Obj((String)metadata.get("IS_NULLABLE"));
        this.infoSchemaCols = new HashMap<String, Object>();
        this.xml = null;
    }

    SQLField(SQLTable table, SQLField f) {
        super(table, f.getName());
        this.type = f.type;
        this.metadata = new HashMap<String, Object>(f.metadata);
        this.defaultValue = f.defaultValue;
        this.fullName = f.fullName;
        this.nullable = f.nullable;
        this.infoSchemaCols = new HashMap<String, Object>(f.infoSchemaCols);
        this.xml = f.xml;
    }

    synchronized void mutateTo(SQLField f) {
        if (this == f) {
            return;
        }
        this.type = f.type;
        this.metadata.clear();
        this.metadata.putAll(f.metadata);
        this.defaultValue = f.defaultValue;
        this.nullable = f.nullable;
        this.setColsFromInfoSchema(f.infoSchemaCols);
        this.xml = f.xml;
    }

    synchronized void setColsFromInfoSchema(Map m) {
        this.infoSchemaCols.clear();
        this.infoSchemaCols.putAll(m);
        this.infoSchemaCols.keySet().removeAll(SQLSyntax.INFO_SCHEMA_NAMES_KEYS);
    }

    public String toString() {
        return "|" + this.getFullName() + "|";
    }

    public final synchronized String getFullName() {
        return this.fullName;
    }

    @Override
    public SQLTable getTable() {
        return (SQLTable)this.getParent();
    }

    public synchronized SQLType getType() {
        return this.type;
    }

    public synchronized Object getMetadata(String name) {
        return this.metadata.get(name);
    }

    public final synchronized Map<String, Object> getInfoSchema() {
        return Collections.unmodifiableMap(this.infoSchemaCols);
    }

    public final SQLName getOwnedSequence() {
        return this.getOwnedSequence(false);
    }

    public final SQLName getOwnedSequence(boolean allowRequest) {
        SQLSystem sys = this.getServer().getSQLSystem();
        if (sys == SQLSystem.H2) {
            String name = (String)this.infoSchemaCols.get("SEQUENCE_NAME");
            if (name != null) {
                return new SQLName(this.getDBRoot().getName(), name);
            }
        } else if (sys == SQLSystem.POSTGRESQL) {
            if (allowRequest) {
                String req = "SELECT pg_get_serial_sequence(" + this.getTable().getBase().quoteString(this.getTable().getSQLName().quote()) + ", " + this.getTable().getBase().quoteString(this.getName()) + ")";
                String name = (String)this.getDBSystemRoot().getDataSource().executeScalar(req);
                if (name != null) {
                    return SQLName.parse(name);
                }
            } else {
                String def = ((String)this.getDefaultValue()).trim();
                if (def.startsWith("nextval")) {
                    Matcher matcher = SEQ_PATTERN.matcher(def);
                    if (matcher.matches()) {
                        return SQLName.parse(matcher.group(1));
                    }
                    throw new IllegalStateException("could not parse: " + def + " with " + SEQ_PATTERN.pattern());
                }
            }
        }
        return null;
    }

    public synchronized Object getDefaultValue() {
        return this.defaultValue;
    }

    public final synchronized Boolean isNullable() {
        return this.nullable;
    }

    public boolean isKey() {
        return this.getTable().getKeys().contains(this);
    }

    public boolean isPrimaryKey() {
        return this.getTable().getPrimaryKeys().equals(Collections.singleton(this));
    }

    public final SQLTable getForeignTable() {
        return this.getDBSystemRoot().getGraph().getForeignTable(this);
    }

    @Override
    public SQLField getField() {
        return this;
    }

    @Override
    public String getFieldRef() {
        return String.valueOf(SQLBase.quoteIdentifier(this.getAlias())) + "." + SQLBase.quoteIdentifier(this.getField().getName());
    }

    @Override
    public String getAlias() {
        return this.getTable().getName();
    }

    @Override
    public TableRef getTableRef() {
        return this.getTable();
    }

    public synchronized String toXML() {
        if (this.xml == null) {
            StringBuilder sb = new StringBuilder(2048);
            sb.append("<field name=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()));
            sb.append("\" >");
            sb.append(this.type.toXML());
            sb.append(XMLCodecUtils.encodeSimple(this.metadata));
            sb.append("<infoSchema>");
            sb.append(XMLCodecUtils.encodeSimple(this.infoSchemaCols));
            sb.append("</infoSchema></field>\n");
            this.xml = sb.toString();
        }
        return this.xml;
    }

    @Override
    public Map<String, ? extends DBStructureItemJDBC> getChildrenMap() {
        return Collections.emptyMap();
    }

    @Override
    public FieldPath getFieldPath() {
        return new FieldPath(this);
    }

    @Override
    public Path getPath() {
        return Path.get(this.getTable());
    }

    @Override
    public String getFieldName() {
        return this.getName();
    }

    public static enum Properties {
        NAME,
        TYPE,
        DEFAULT,
        NULLABLE;

    }
}

