/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.DocumentationEditorFrame;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldMapper;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.utils.i18n.TranslationManager;

public class GroupSQLComponent
extends BaseSQLComponent {
    private final Group group;
    private final int columns = 2;
    private final Map<String, JComponent> labels = new HashMap<String, JComponent>();
    private final Map<String, JComponent> editors = new HashMap<String, JComponent>();
    private String startTabAfter = null;
    private boolean tabGroup;
    private int tabDepth;
    private JTabbedPane pane;

    public GroupSQLComponent(SQLElement element, Group group) {
        super(element);
        this.group = group;
    }

    @Override
    protected void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        this.tabGroup = false;
        this.tabDepth = 0;
        this.layout(this.group, 0, 0, 0, c, this);
    }

    public void layout(Item currentItem, Integer order, int x, int level, GridBagConstraints c, JPanel panel) {
        String id = currentItem.getId();
        LayoutHints size = currentItem.getLocalHint();
        if (!size.isVisible()) {
            return;
        }
        if (size.isSeparated()) {
            x = 0;
            c.gridx = 0;
            ++c.gridy;
        }
        if (currentItem instanceof Group) {
            Group currentGroup = (Group)currentItem;
            int stop = currentGroup.getSize();
            c.weighty = 0.0;
            if (this.tabGroup && level == this.tabDepth) {
                panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.setOpaque(false);
                c = new DefaultGridBagConstraints();
                x = 0;
                c.fill = 0;
                String label = TranslationManager.getInstance().getTranslationForItem(id);
                if (label == null) {
                    label = id;
                }
                this.pane.addTab(label, panel);
            } else if (size.showLabel() && this.getLabel(id) != null) {
                x = 0;
                ++c.gridy;
                c.fill = 2;
                c.gridx = 0;
                c.weightx = 1.0;
                c.gridwidth = 4;
                panel.add((Component)this.getLabel(id), c);
                ++c.gridy;
            }
            int i = 0;
            while (i < stop) {
                Item subGroup = currentGroup.getItem(i);
                Integer subGroupOrder = currentGroup.getOrder(i);
                this.layout(subGroup, subGroupOrder, x, level + 1, c, panel);
                ++i;
            }
            if (this.tabGroup && level == this.tabDepth) {
                JPanel spacer = new JPanel();
                spacer.setOpaque(false);
                ++c.gridy;
                c.weighty = 1.0E-4;
                panel.add((Component)spacer, c);
            }
        } else {
            c.gridwidth = 1;
            if (size.showLabel()) {
                c.weightx = 0.0;
                c.weighty = 0.0;
                if (size.isSeparated()) {
                    c.gridwidth = 4;
                    c.weightx = 1.0;
                    c.fill = 0;
                } else {
                    c.fill = 2;
                }
                panel.add((Component)this.getLabel(id), c);
                if (size.isSeparated()) {
                    ++c.gridy;
                    c.gridx = 0;
                } else {
                    ++c.gridx;
                }
            }
            JComponent editor = this.getEditor(id);
            if (size.fillWidth() && size.fillHeight()) {
                c.fill = 1;
            } else if (size.fillWidth()) {
                c.fill = 2;
            } else if (size.fillHeight()) {
                c.fill = 3;
            } else {
                c.fill = 0;
                DefaultGridBagConstraints.lockMinimumSize(editor);
            }
            c.weighty = size.fillHeight() ? 1.0 : 0.0;
            c.gridwidth = size.largeWidth() ? (size.isSeparated() ? 2 * 2 : 2 * 2 - 1) : (size.showLabel() && !size.isSeparated() ? 1 : 2);
            if (c.gridx % 2 == 1) {
                c.weightx = 1.0;
            }
            panel.add((Component)editor, c);
            try {
                JComponent comp = editor;
                if (editor instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)editor;
                    comp = (JComponent)pane.getViewport().getView();
                }
                this.addView(comp, id);
            }
            catch (Exception e) {
                Log.get().warning(e.getMessage());
            }
            c.gridx = size.largeWidth() ? (size.isSeparated() ? (c.gridx += 4) : (c.gridx += 3)) : ++c.gridx;
            if (c.gridx >= 2 * 2) {
                c.gridx = 0;
                ++c.gridy;
                x = 0;
            }
        }
        if (id.equals(this.startTabAfter)) {
            this.tabGroup = true;
            this.tabDepth = level;
            this.pane = new JTabbedPane();
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.gridwidth = 4;
            panel.add((Component)this.pane, c);
        }
    }

    @Override
    public Component addView(JComponent comp, String id) {
        FieldMapper fieldMapper = PropsConfiguration.getInstance().getFieldMapper();
        SQLField field = null;
        if (fieldMapper != null) {
            field = fieldMapper.getSQLFieldForItem(id);
        }
        if (field == null) {
            field = this.getTable().getFieldRaw(id);
        }
        return super.addView(comp, field.getName());
    }

    public JComponent createEditor(String id) {
        Object comp;
        if (id.startsWith("(") && id.endsWith(")*")) {
            try {
                String table = id.substring(1, id.length() - 2).trim();
                String idEditor = String.valueOf(GlobalMapper.getInstance().getIds(table).get(0)) + ".editor";
                Class cl = (Class)GlobalMapper.getInstance().get(idEditor);
                return (JComponent)cl.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FieldMapper fieldMapper = PropsConfiguration.getInstance().getFieldMapper();
        SQLField field = null;
        if (fieldMapper != null) {
            field = fieldMapper.getSQLFieldForItem(id);
        }
        if (field == null) {
            field = this.getTable().getFieldRaw(id);
        }
        if (field == null) {
            JLabelBold jLabel = new JLabelBold("No field " + id);
            jLabel.setForeground(Color.RED.darker());
            String t = "<html>";
            Set<SQLField> fields = this.getTable().getFields();
            for (SQLField sqlField : fields) {
                t = String.valueOf(t) + sqlField.getFullName() + "<br>";
            }
            t = String.valueOf(t) + "</html>";
            jLabel.setToolTipText(t);
            return jLabel;
        }
        SQLType type = field.getType();
        if (this.getElement().getPrivateElement(field.getName()) != null) {
            SQLComponent sqlcomp = this.getElement().getPrivateElement(field.getName()).createDefaultComponent();
            DefaultElementSQLObject dobj = new DefaultElementSQLObject(this, sqlcomp);
            dobj.setDecorated(false);
            dobj.showSeparator(false);
            DefaultGridBagConstraints.lockMinimumSize(sqlcomp);
            comp = dobj;
        } else if (field.isKey()) {
            SQLElement foreignElement = this.getElement().getForeignElement(field.getName());
            if (foreignElement == null) {
                comp = new JLabelBold("no element for foreignd " + id);
                ((JComponent)comp).setForeground(Color.RED.darker());
                Log.get().severe("no element for foreign " + field.getName());
            } else {
                comp = new ElementComboBox();
                ((ElementComboBox)comp).init(foreignElement);
            }
            ((JComponent)comp).setOpaque(false);
        } else if (Boolean.class.isAssignableFrom(type.getJavaType())) {
            comp = new JCheckBox(" ");
            ((JComponent)comp).setOpaque(false);
        } else if (Date.class.isAssignableFrom(type.getJavaType())) {
            comp = new JDate();
            ((JComponent)comp).setOpaque(false);
        } else {
            comp = new JTextField(Math.min(30, type.getSize()));
        }
        return comp;
    }

    protected JComponent createLabel(String id) {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        this.registerPopupMenu(jLabel, id);
        return jLabel;
    }

    private void registerPopupMenu(final JComponent label, final String id) {
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && e.getModifiersEx() == 128) {
                    JPopupMenu popMenu = new JPopupMenu();
                    JMenu menuItemInfo = new JMenu("Information");
                    menuItemInfo.add(new JMenuItem("id: " + id));
                    menuItemInfo.add(new JMenuItem("label: " + GroupSQLComponent.this.getLabel(id).getClass().getName()));
                    menuItemInfo.add(new JMenuItem("editor: " + GroupSQLComponent.this.getEditor(id).getClass().getName()));
                    popMenu.add(menuItemInfo);
                    JMenuItem menuItemDoc = new JMenuItem("Modifier la documentation");
                    menuItemDoc.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            new DocumentationEditorFrame(GroupSQLComponent.this, id).setVisible(true);
                        }
                    });
                    popMenu.add(menuItemDoc);
                    popMenu.show(label, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    protected void updateUI(String id, RowItemDesc desc) {
        super.updateUI(id, desc);
        this.updateUI(id, this.getLabel(id), desc, Color.RED.darker());
    }

    public JComponent getLabel(String id) {
        JComponent label = this.labels.get(id);
        if (label == null) {
            label = this.createLabel(id);
            this.labels.put(id, label);
            RowItemDesc rivDesc = this.getRIVDescForId(id);
            this.updateUI(id, rivDesc);
        }
        return label;
    }

    private RowItemDesc getRIVDescForId(String id) {
        SQLField sqlFieldForItem;
        FieldMapper fieldMapper = PropsConfiguration.getInstance().getFieldMapper();
        String t = TranslationManager.getInstance().getTranslationForItem(id);
        if (t != null) {
            return new RowItemDesc(t, t);
        }
        String fieldName = null;
        if (fieldMapper != null && (sqlFieldForItem = fieldMapper.getSQLFieldForItem(id)) != null) {
            fieldName = sqlFieldForItem.getName();
        }
        if (fieldName == null) {
            fieldName = id;
        }
        RowItemDesc rivDesc = this.getRIVDesc(fieldName);
        return rivDesc;
    }

    public JComponent getEditor(String id) {
        JComponent editor = this.editors.get(id);
        if (editor == null) {
            editor = this.createEditor(id);
            this.editors.put(id, editor);
        }
        return editor;
    }
}

