/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.sync.SyncClient;

public class CloudStorageEngine
implements StorageEngine {
    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public boolean allowAutoStorage() {
        return true;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void disconnect() throws IOException {
    }

    @Override
    public void store(InputStream inStream, String remotePath, String title, boolean synchronous) throws IOException {
        File localFile = File.createTempFile("OpenConcerto", title);
        remotePath = remotePath.replace('\\', '/');
        try {
            try {
                ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
                remotePath = String.valueOf(config.getSocieteID()) + "/" + remotePath;
                SyncClient client = new SyncClient("https://" + config.getStorageServer());
                client.setVerifyHost(false);
                StreamUtils.copy(inStream, localFile);
                Log.get().info("Sending file:" + localFile.getCanonicalPath() + " to " + remotePath + " " + title + " size:" + localFile.length());
                if (localFile.length() > 0L) {
                    client.sendFile(localFile, remotePath, title, config.getToken());
                } else {
                    Log.get().warning("Skiping empty file:" + localFile.getCanonicalPath() + " to " + remotePath + " " + title);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            if (localFile.exists()) {
                localFile.delete();
            }
        }
    }
}

