/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class DevisCommandeSQLInjector
extends SQLInjector {
    public DevisCommandeSQLInjector(DBRoot root) {
        super(root, "DEVIS", "COMMANDE_CLIENT", true);
        SQLTable tableDevis = this.getSource();
        SQLTable tableCommande = this.getDestination();
        this.map(tableDevis.getField("ID_CLIENT"), tableCommande.getField("ID_CLIENT"));
        this.mapDefaultValues(tableCommande.getField("SOURCE"), tableDevis.getName());
        this.map(tableDevis.getField("ID_DEVIS"), tableCommande.getField("IDSOURCE"));
        this.map(tableDevis.getField("ID_DEVIS"), tableCommande.getField("ID_DEVIS"));
        this.map(tableDevis.getField("ID_COMMERCIAL"), tableCommande.getField("ID_COMMERCIAL"));
        if (tableDevis.getTable().contains("ID_POLE_PRODUIT")) {
            this.map(tableDevis.getField("ID_POLE_PRODUIT"), tableCommande.getField("ID_POLE_PRODUIT"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("DEVIS_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("COMMANDE_CLIENT_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertReference(srcRow, rowVals, "OBJET", "NOM");
        this.transfertReference(srcRow, rowVals, "INFOS", "INFOS");
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_COMMANDE_CLIENT");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_COMMANDE_CLIENT", rowVals);
            }
        }
    }
}

