/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationReglementVenteNG
extends GenerationEcritures {
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private static final SQLTable tableEncaisse = base.getTable("ENCAISSER_MONTANT");
    private static final SQLTable tableEncaisseElt = base.getTable("ENCAISSER_MONTANT_ELEMENT");
    private static final SQLTable tableSaisieVenteFacture = base.getTable("SAISIE_VENTE_FACTURE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationReglementVenteNG(String label, SQLRow rowClient, PrixTTC ttc, Date d, SQLRow modeReglement, SQLRow source, SQLRow mvtSource) throws Exception {
        this(label, rowClient, ttc, d, modeReglement, source, mvtSource, true);
    }

    public GenerationReglementVenteNG(String label, SQLRow rowClient, PrixTTC ttc, Date d, SQLRow modeReglement, SQLRow source, SQLRow mvtSource, boolean createEncaisse) throws Exception {
        SQLRow typeRegRow = modeReglement.getForeignRow("ID_TYPE_REGLEMENT");
        this.date = d;
        this.nom = label;
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.fillJournalBanqueFromRow(modeReglement);
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        if (source.getTable().getName().equalsIgnoreCase("ENCAISSER_MONTANT")) {
            Collection l = source.getReferentRows(source.getTable().getTable("ENCAISSER_MONTANT_ELEMENT"));
            for (SQLRow sqlRow : l) {
                SQLRow mvtEch = sqlRow.getForeignRow("ID_MOUVEMENT_ECHEANCE");
                if (mvtEch.getID() == mvtSource.getID()) continue;
                this.getNewMouvement(source.getTable().getName(), source.getID(), mvtEch.getID(), mvtEch.getInt("ID_PIECE"));
            }
        }
        if (!typeRegRow.getBoolean("ECHEANCE").booleanValue() && (modeReglement.getBoolean("COMPTANT").booleanValue() || !modeReglement.getBoolean("DATE_FACTURE").booleanValue() && modeReglement.getInt("AJOURS") == 0 && modeReglement.getInt("LENJOUR") == 0)) {
            Calendar c2;
            SQLRowValues rowVals;
            SQLRow rowEncaisse = source;
            SQLRow rowEncaisseElt = null;
            if (createEncaisse) {
                rowVals = new SQLRowValues(tableEncaisse);
                rowVals.put("MONTANT", ttc.getLongValue());
                rowVals.put("ID_CLIENT", rowClient.getID());
                rowVals.put("DATE", this.date);
                if (typeRegRow.getID() >= 5 && (c2 = modeReglement.getDate("DATE_VIREMENT")) != null) {
                    rowVals.put("DATE", c2.getTime());
                }
                SQLRowValues rowValsRegl = new SQLRowValues(modeReglement.asRowValues());
                SQLRow copy = rowValsRegl.insert();
                rowVals.put("ID_MODE_REGLEMENT", copy.getID());
                rowVals.put("NOM", label);
                rowEncaisse = rowVals.insert();
                SQLRowValues rowValsElt = new SQLRowValues(tableEncaisseElt);
                rowValsElt.put("MONTANT_REGLE", ttc.getLongValue());
                rowValsElt.put("ID_ENCAISSER_MONTANT", rowEncaisse.getID());
                rowEncaisseElt = rowValsElt.insert();
            }
            this.idMvt = this.getNewMouvement(rowEncaisse.getTable().getName(), rowEncaisse.getID(), mvtSource.getID(), mvtSource.getInt("ID_PIECE"));
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
            rowVals = rowEncaisse.createEmptyUpdateRow();
            rowVals.put("ID_MOUVEMENT", this.idMvt);
            rowVals.update();
            if (rowEncaisseElt != null) {
                SQLRowValues rowVals2 = rowEncaisseElt.createEmptyUpdateRow();
                rowVals2.put("ID_MOUVEMENT_ECHEANCE", this.idMvt);
                rowVals2.update();
            }
            if (typeRegRow.getID() == 2) {
                Date dateTmp = this.date;
                if (modeReglement.getObject("DATE") != null) {
                    dateTmp = modeReglement.getDate("DATE").getTime();
                }
                this.setDateReglement(source, dateTmp);
                Calendar c = modeReglement.getDate("DATE_DEPOT");
                if (c != null) {
                    this.paiementCheque(c.getTime(), source, ttc, rowClient.getID(), modeReglement, mvtSource.getTable().getRow(this.idMvt));
                } else {
                    this.paiementCheque(this.date, source, ttc, rowClient.getID(), modeReglement, mvtSource.getTable().getRow(this.idMvt));
                }
            } else {
                int idCompteClient;
                if (typeRegRow.getID() >= 5) {
                    c2 = modeReglement.getDate("DATE_VIREMENT");
                    if (c2 == null) {
                        this.setDateReglement(source, this.date);
                    } else {
                        this.setDateReglement(source, c2.getTime());
                    }
                } else {
                    this.setDateReglement(source, this.date);
                }
                if (typeRegRow.getID() == 4) {
                    this.mEcritures.put("ID_JOURNAL", 5);
                }
                if ((idCompteClient = rowClient.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                    idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                }
                this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", ttc.getLongValue());
                this.ajoutEcriture();
                if (typeRegRow.getID() == 4) {
                    int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_CLIENT");
                    if (idCompteRegl <= 1) {
                        idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("VenteEspece");
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteRegl);
                } else {
                    this.fillCompteBanqueFromRow(modeReglement, "VenteCB", false);
                }
                this.mEcritures.put("DEBIT", ttc.getLongValue());
                this.mEcritures.put("CREDIT", 0L);
                this.ajoutEcriture();
            }
        } else {
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeReglement.getInt("AJOURS"), modeReglement.getInt("LENJOUR"), this.date);
            System.out.println("Ech\u00e9ance client");
            SQLTable tableEch = base.getTable("ECHEANCE_CLIENT");
            SQLRowValues valEcheance = new SQLRowValues(tableEch);
            this.idMvt = this.getNewMouvement("ECHEANCE_CLIENT", 1, mvtSource.getID(), mvtSource.getInt("ID_PIECE"));
            valEcheance.put("ID_MOUVEMENT", (Object)this.idMvt);
            valEcheance.put("DATE", dateEch);
            valEcheance.put("MONTANT", ttc.getLongValue());
            valEcheance.put("ID_CLIENT", rowClient.getID());
            if (source.getTable().equals(tableSaisieVenteFacture)) {
                valEcheance.put("ID_SAISIE_VENTE_FACTURE", source.getID());
            }
            SQLRow row = valEcheance.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }

    private void setDateReglement(SQLRow source, Date d) throws SQLException {
        ArrayList<SQLRow> sources = new ArrayList<SQLRow>();
        if (source.getTable().getName().equalsIgnoreCase("ENCAISSER_MONTANT")) {
            Collection rows = source.getReferentRows(source.getTable().getTable("ENCAISSER_MONTANT_ELEMENT"));
            for (SQLRow sqlRow : rows) {
                SQLRow rowMvt;
                SQLRow rowEch = sqlRow.getForeignRow("ID_ECHEANCE_CLIENT");
                if (rowEch == null || rowEch.getID() <= 1 || !(rowMvt = tableMouvement.getRow(MouvementSQLElement.getSourceId(rowEch.getInt("ID_MOUVEMENT")))).getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) continue;
                sources.add(tableSaisieVenteFacture.getRow(rowMvt.getInt("IDSOURCE")));
            }
        } else {
            sources.add(source);
        }
        for (SQLRow sqlRow : sources) {
            if (!sqlRow.getTable().getName().equalsIgnoreCase("SAISIE_VENTE_FACTURE")) continue;
            SQLRowValues rowValsUpdateVF = sqlRow.createEmptyUpdateRow();
            rowValsUpdateVF.put("DATE_REGLEMENT", new Timestamp(d.getTime()));
            rowValsUpdateVF.update();
        }
    }

    private void paiementCheque(Date dateEch, SQLRow source, PrixTTC ttc, int idClient, SQLRow modeRegl, SQLRow mvtSource) throws SQLException {
        SQLRowValues valCheque = new SQLRowValues(base.getTable("CHEQUE_A_ENCAISSER"));
        valCheque.put("ID_CLIENT", idClient);
        String foreignBanqueFieldName = "ID_" + BanqueSQLElement.TABLENAME;
        if (valCheque.getTable().contains(foreignBanqueFieldName)) {
            valCheque.put(foreignBanqueFieldName, modeRegl.getInt(foreignBanqueFieldName));
        }
        valCheque.put("NUMERO", modeRegl.getObject("NUMERO"));
        valCheque.put("DATE", modeRegl.getObject("DATE"));
        valCheque.put("ETS", modeRegl.getObject("ETS"));
        valCheque.put("DATE_VENTE", this.date);
        this.idMvt = this.getNewMouvement("CHEQUE_A_ENCAISSER", 1, mvtSource.getID(), mvtSource.getInt("ID_PIECE"));
        valCheque.put("DATE_MIN_DEPOT", dateEch);
        valCheque.put("ID_MOUVEMENT", (Object)this.idMvt);
        valCheque.put("MONTANT", ttc.getLongValue());
        if (valCheque.getInvalid() == null) {
            SQLRow row = valCheque.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }
}

