/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.concurrent.Callable;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtTicketCaisse
extends GenerationEcritures {
    private final SQLRow rowTicket;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtTicketCaisse(SQLRow ticket, int idMvt) {
        System.err.println("********* init GeneRation");
        this.idMvt = idMvt;
        this.rowTicket = ticket;
    }

    public GenerationMvtTicketCaisse(SQLRow ticket) {
        this(ticket, 1);
    }

    public Callable<Integer> genereMouvement() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                SQLRow clientRow = GenerationMvtTicketCaisse.this.rowTicket.getForeignRow("ID_CLIENT");
                int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                GenerationMvtTicketCaisse.this.date = GenerationMvtTicketCaisse.this.rowTicket.getDate("DATE").getTime();
                GenerationMvtTicketCaisse.this.nom = "Ticket " + GenerationMvtTicketCaisse.this.rowTicket.getString("NUMERO");
                GenerationMvtTicketCaisse.this.mEcritures.put("DATE", GenerationMvtTicketCaisse.this.date);
                GenerationMvtTicketCaisse.this.mEcritures.put("NOM", GenerationMvtTicketCaisse.this.nom);
                GenerationMvtTicketCaisse.this.mEcritures.put("ID_JOURNAL", GenerationMvtSaisieVenteFacture.journal);
                GenerationMvtTicketCaisse.this.mEcritures.put("ID_MOUVEMENT", 1);
                if (GenerationMvtTicketCaisse.this.idMvt == 1) {
                    GenerationMvtTicketCaisse.this.getNewMouvement("TICKET_CAISSE", GenerationMvtTicketCaisse.this.rowTicket.getID(), 1, GenerationMvtTicketCaisse.this.nom);
                } else {
                    GenerationMvtTicketCaisse.this.mEcritures.put("ID_MOUVEMENT", GenerationMvtTicketCaisse.this.idMvt);
                }
                TotalCalculator calc = GenerationMvtTicketCaisse.this.getValuesFromElement(GenerationMvtTicketCaisse.this.rowTicket, GenerationMvtTicketCaisse.this.rowTicket.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT"), BigDecimal.ZERO, null, null);
                long ttcLongValue = calc.getTotalTTC().movePointRight(2).longValue();
                for (SQLRowAccessor row : calc.getMapHt().keySet()) {
                    long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                    if (b == 0L) continue;
                    GenerationMvtTicketCaisse.this.mEcritures.put("ID_COMPTE_PCE", row.getID());
                    GenerationMvtTicketCaisse.this.mEcritures.put("DEBIT", 0L);
                    GenerationMvtTicketCaisse.this.mEcritures.put("CREDIT", b);
                    GenerationMvtTicketCaisse.this.ajoutEcriture();
                }
                Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
                for (SQLRowAccessor rowAc : tvaMap.keySet()) {
                    long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                    if (longValue == 0L) continue;
                    GenerationMvtTicketCaisse.this.mEcritures.put("ID_COMPTE_PCE", rowAc.getID());
                    GenerationMvtTicketCaisse.this.mEcritures.put("DEBIT", 0L);
                    GenerationMvtTicketCaisse.this.mEcritures.put("CREDIT", longValue);
                    GenerationMvtTicketCaisse.this.ajoutEcriture();
                }
                if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                    try {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                GenerationMvtTicketCaisse.this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
                GenerationMvtTicketCaisse.this.mEcritures.put("DEBIT", ttcLongValue);
                GenerationMvtTicketCaisse.this.mEcritures.put("CREDIT", 0L);
                GenerationMvtTicketCaisse.this.ajoutEcriture();
                return GenerationMvtTicketCaisse.this.idMvt;
            }
        };
        return c;
    }
}

