/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtSaisieKm
extends GenerationEcritures {
    private int idSaisieKm;

    public GenerationMvtSaisieKm(int idSaisieKm) {
        this.idSaisieKm = idSaisieKm;
    }

    public int genereMouvement() throws SQLException {
        SQLRow saisieRow = base.getTable("SAISIE_KM").getRow(this.idSaisieKm);
        this.date = (Date)saisieRow.getObject("DATE");
        this.nom = saisieRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", saisieRow.getObject("ID_JOURNAL"));
        this.mEcritures.put("ID_MOUVEMENT", new Integer(1));
        this.getNewMouvement("SAISIE_KM", this.idSaisieKm, 1, "Saisie au km " + saisieRow.getObject("NOM").toString());
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_KM_ELEMENT");
        Collection set = saisieRow.getReferentRows(tableElt);
        SQLTable tableAssoc = Configuration.getInstance().getRoot().findTable("ASSOCIATION_ANALYTIQUE");
        for (SQLRow rowElement : set) {
            int idCpt = ComptePCESQLElement.getId(rowElement.getString("NUMERO"), rowElement.getString("NOM"));
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCpt));
            this.mEcritures.put("NOM", rowElement.getString("NOM_ECRITURE"));
            this.mEcritures.put("DEBIT", rowElement.getObject("DEBIT"));
            this.mEcritures.put("CREDIT", rowElement.getObject("CREDIT"));
            SQLRow rowEcr = this.ajoutEcriture();
            Collection assocs = rowElement.getReferentRows(tableAssoc);
            for (SQLRow sqlRow : assocs) {
                if (sqlRow.isUndefined()) continue;
                this.addAssocAnalytique(rowEcr, sqlRow.getInt("ID_POSTE_ANALYTIQUE"));
            }
            if (rowEcr == null || rowEcr.isUndefined()) continue;
            SQLRowValues vals = rowElement.createEmptyUpdateRow();
            vals.put("ID_ECRITURE", rowEcr.getID());
            vals.update();
        }
        return this.idMvt;
    }
}

