/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementFactureFournisseur;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtFactureFournisseur
extends GenerationEcritures
implements Runnable {
    private int idFacture;
    private static final Integer journal = new Integer(2);
    private static final SQLTable tableFacture = base.getTable("FACTURE_FOURNISSEUR");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableFournisseur = base.getTable("FOURNISSEUR");
    private static final SQLTable tableMvt = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtFactureFournisseur(int idFacture, int idMvt) {
        this.idFacture = idFacture;
        this.idMvt = idMvt;
        new Thread(this).start();
    }

    public GenerationMvtFactureFournisseur(int idFacture) {
        this.idFacture = idFacture;
        this.idMvt = 1;
        new Thread(this).start();
    }

    public void genereMouvement() throws Exception {
        SQLRowValues rowValsPiece;
        SQLRow saisieRow = tableFacture.getRow(this.idFacture);
        SQLRow rowFournisseur = tableFournisseur.getRow(saisieRow.getInt("ID_FOURNISSEUR"));
        this.date = (Date)saisieRow.getObject("DATE");
        this.nom = "Achat : " + rowFournisseur.getString("NOM") + " Facture : " + saisieRow.getObject("NUMERO").toString() + " " + saisieRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", journal);
        this.mEcritures.put("ID_MOUVEMENT", new Integer(1));
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            rowValsPiece.put("NOM", saisieRow.getObject("NUMERO").toString());
            this.getNewMouvement("FACTURE_FOURNISSEUR", this.idFacture, 1, rowValsPiece);
        } else {
            rowValsPiece = pieceTable.getTable("MOUVEMENT").getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            rowValsPiece.put("NOM", saisieRow.getObject("NUMERO").toString());
            rowValsPiece.update();
            this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
        }
        SQLRow rowCompteAchat = saisieRow.getForeign("ID_COMPTE_PCE");
        if ((rowCompteAchat == null || rowCompteAchat.isUndefined()) && ((rowCompteAchat = rowPrefsCompte.getForeign("ID_COMPTE_PCE_ACHAT")) == null || rowCompteAchat.isUndefined())) {
            rowCompteAchat = ComptePCESQLElement.getRowComptePceDefault("Achats");
        }
        TotalCalculator calc = this.getValuesFromElement(true, "T_PA_HT", saisieRow, saisieRow.getTable().getTable("FACTURE_FOURNISSEUR_ELEMENT"), BigDecimal.ZERO, null, null, rowCompteAchat);
        long ttcLongValue = calc.getTotalTTC().movePointRight(2).longValue();
        long htLongValue = calc.getTotalHT().movePointRight(2).longValue();
        for (SQLRowAccessor row : calc.getMapHt().keySet()) {
            long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (b == 0L) continue;
            this.mEcritures.put("ID_COMPTE_PCE", row.getID());
            this.mEcritures.put("CREDIT", 0L);
            this.mEcritures.put("DEBIT", b);
            SQLRow rowEcr = this.ajoutEcriture();
            this.addAssocAnalytiqueFromProvider(rowEcr, saisieRow);
        }
        Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
        for (SQLRowAccessor rowAc : tvaMap.keySet()) {
            long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (longValue == 0L) continue;
            this.mEcritures.put("ID_COMPTE_PCE", rowAc.getID());
            this.mEcritures.put("CREDIT", 0L);
            this.mEcritures.put("DEBIT", longValue);
            this.ajoutEcriture();
            if (!rowFournisseur.getBoolean("UE").booleanValue()) continue;
            int idCompteTVAIntra = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_INTRA");
            if (idCompteTVAIntra <= 1) {
                idCompteTVAIntra = ComptePCESQLElement.getIdComptePceDefault("TVAIntraComm");
            }
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteTVAIntra));
            this.mEcritures.put("DEBIT", new Long(0L));
            this.mEcritures.put("CREDIT", new Long(longValue));
            this.ajoutEcriture();
        }
        int idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE");
        if (idCompteFourn <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
            idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
        }
        this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteFourn));
        this.mEcritures.put("DEBIT", new Long(0L));
        if (rowFournisseur.getBoolean("UE").booleanValue()) {
            this.mEcritures.put("CREDIT", new Long(htLongValue));
        } else {
            this.mEcritures.put("CREDIT", new Long(ttcLongValue));
        }
        this.ajoutEcriture();
        new GenerationMvtReglementFactureFournisseur(this.idFacture, this.idMvt);
        SQLRowValues valEcriture = new SQLRowValues(tableFacture);
        valEcriture.put("ID_MOUVEMENT", new Integer(this.idMvt));
        if (valEcriture.getInvalid() == null) {
            valEcriture.update(this.idFacture);
            this.displayMvtNumber();
        }
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
        }
    }
}

