/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class PaiementRemainedProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        return this.getRestant(row);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("invoice.paiement.remained", new PaiementRemainedProvider());
    }

    private BigDecimal getRestant(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("ECHEANCE_CLIENT"));
        long totalEch = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.getBoolean("REGLE").booleanValue() || sQLRowAccessor.getBoolean("REG_COMPTA").booleanValue()) continue;
            totalEch += sQLRowAccessor.getLong("MONTANT");
        }
        return new BigDecimal(totalEch).movePointLeft(2);
    }
}

