/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.generationDoc.MetaDataSheet;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLElement;
import org.openconcerto.erp.generationDoc.OOXMLTableElement;
import org.openconcerto.erp.generationDoc.OOXMLTableField;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StreamUtils;

public class OOgenerationXML {
    private static int answer = 1;
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private Map<Sheet, Map<String, Map<Integer, String>>> cacheStyle = new HashMap<Sheet, Map<String, Map<Integer, String>>>();
    private Map<SQLRowAccessor, Map<String, Object>> taxe = new HashMap<SQLRowAccessor, Map<String, Object>>();
    private Map<String, Map<Integer, SQLRowAccessor>> cacheForeign = new HashMap<String, Map<Integer, SQLRowAccessor>>();
    private Map<String, List<? extends SQLRowAccessor>> rowsEltCache = new HashMap<String, List<? extends SQLRowAccessor>>();
    private final OOXMLCache rowRefCache = new OOXMLCache();
    private final SQLRow row;

    public OOgenerationXML(SQLRow row) {
        this.row = row;
    }

    public synchronized File createDocument(String templateId, String typeTemplate, File outputDirectory, final String expectedFileName, SQLRow rowLanguage, MetaDataSheet meta) {
        SpreadSheet spreadSheet;
        InputStream templateStream;
        List listElts;
        Element racine;
        block18: {
            String langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
            this.cacheStyle.clear();
            this.rowRefCache.clearCache();
            this.rowsEltCache.clear();
            this.taxe.clear();
            this.cacheForeign.clear();
            File fDest = new File(outputDirectory, expectedFileName);
            if (fDest.exists()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    answer = JOptionPane.showConfirmDialog(null, "Voulez vous reg\u00e9n\u00e9rer et \u00e9craser l'ancien document?", "G\u00e9n\u00e9ration du document", 0);
                    Thread.dumpStack();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                answer = JOptionPane.showConfirmDialog(null, "Voulez vous reg\u00e9n\u00e9rer et \u00e9craser l'ancien document?", "G\u00e9n\u00e9ration du document", 0);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                if (answer != 0) {
                    return fDest;
                }
            }
            Date d = new Date();
            SAXBuilder builder = new SAXBuilder();
            if (this.needAnnexe(templateId, typeTemplate, this.row, rowLanguage)) {
                String annexeTemplateId = String.valueOf(templateId) + "_annexe";
                InputStream annexeStream = TemplateManager.getInstance().getTemplate(annexeTemplateId, langage, typeTemplate);
                if (annexeStream != null) {
                    templateId = annexeTemplateId;
                    System.err.println("modele With annexe " + templateId);
                }
            }
            System.err.println("Using template id: " + templateId);
            InputStream xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, langage, typeTemplate);
            Document doc = builder.build(xmlConfiguration);
            racine = doc.getRootElement();
            listElts = racine.getChildren("element");
            templateStream = TemplateManager.getInstance().getTemplate(templateId, langage, typeTemplate);
            if (templateStream != null) break block18;
            ExceptionHandler.handle("Mod\u00e8le " + templateId + " " + (rowLanguage == null ? "" : rowLanguage.getString("CHEMIN")) + " " + typeTemplate + " manquant.");
            return null;
        }
        try {
            spreadSheet = new ODPackage(templateStream).getSpreadSheet();
            this.parseElementsXML(listElts, this.row, spreadSheet);
            List listTable = racine.getChildren("table");
            for (Element tableChild : listTable) {
                this.parseTableauXML(tableChild, spreadSheet, rowLanguage);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de remplir le document " + templateId + " " + (rowLanguage == null ? "" : rowLanguage.getString("CHEMIN")), e);
            return null;
        }
        try {
            if (meta != null) {
                meta.applyTo(spreadSheet.getPackage().getMeta(true));
            }
            return OOgenerationXML.saveSpreadSheet(spreadSheet, outputDirectory, expectedFileName, templateId, rowLanguage);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration du fichier " + expectedFileName, e);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du fichier " + expectedFileName, e);
                }
            });
        }
        return null;
    }

    private void parseTableauXML(Element tableau, SpreadSheet spreadsheet, SQLRow rowLanguage) {
        if (tableau == null) {
            return;
        }
        String o = tableau.getAttributeValue("sheet");
        int idSheet = o == null ? 0 : Integer.valueOf(o.toString().trim());
        Sheet sheet = spreadsheet.getSheet(idSheet);
        String oLastColTmp = tableau.getAttributeValue("lastColumn");
        int lastColumn = -1;
        int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        if (oLastColTmp != null) {
            lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
        }
        Map<String, Map<Integer, String>> mapStyle = this.searchStyle(sheet, lastColumn, endPageLine);
        if (tableau.getAttributeValue("table").equalsIgnoreCase("TVA")) {
            this.fillTaxe(tableau, sheet, mapStyle, false);
            return;
        }
        int nbPage = this.fillTable(tableau, this.row, sheet, mapStyle, true, rowLanguage);
        int firstLine = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        int endLine = Integer.valueOf(tableau.getAttributeValue("endLine"));
        Object printRangeObj = sheet.getPrintRanges();
        System.err.println("Nombre de page == " + nbPage);
        if (nbPage == 1) {
            this.fillTable(tableau, this.row, sheet, mapStyle, false, rowLanguage);
        } else {
            String pageRef;
            if (printRangeObj != null) {
                String s = printRangeObj.toString();
                String[] range = s.split(":");
                int i = 0;
                while (i < range.length) {
                    String string = range[i];
                    range[i] = string.subSequence(string.indexOf(46) + 1, string.length()).toString();
                    ++i;
                }
                int rowEnd = -1;
                if (range.length > 1) {
                    rowEnd = sheet.resolveHint((String)range[1]).y + 1;
                    int rowEndNew = rowEnd * nbPage;
                    String sNew = s.replaceAll(String.valueOf(rowEnd), String.valueOf(rowEndNew));
                    sheet.setPrintRanges(sNew);
                    System.err.println(" ******  Replace print ranges; Old:" + rowEnd + "--" + s + " New:" + rowEndNew + "--" + sNew);
                }
            }
            sheet.duplicateFirstRows(endLine, 1);
            int lineToAdd = endPageLine - endLine;
            String repeatedCount = tableau.getAttributeValue("repeatedCount");
            if (repeatedCount != null && repeatedCount.trim().length() > 0) {
                int count = Integer.valueOf(repeatedCount);
                sheet.duplicateRows(firstLine, lineToAdd / count, count);
                int rest = lineToAdd % count;
                if (rest != 0) {
                    sheet.insertDuplicatedRows(firstLine + lineToAdd - rest, rest);
                }
            } else {
                sheet.insertDuplicatedRows(firstLine, lineToAdd);
            }
            System.err.println("nbPage == " + nbPage);
            if (nbPage > 2) {
                sheet.duplicateFirstRows(endPageLine, nbPage - 2);
            }
            if ((pageRef = tableau.getAttributeValue("pageRef")) != null && pageRef.trim().length() > 0) {
                MutableCell cell = sheet.getCellAt(pageRef);
                cell.setValue((Object)("Page 1/" + nbPage));
                int i = 1;
                while (i < nbPage) {
                    MutableCell cell2 = sheet.getCellAt(cell.getX(), cell.getY() + endPageLine * i);
                    cell2.setValue((Object)("Page " + (i + 1) + "/" + nbPage));
                    ++i;
                }
            }
            this.fillTable(tableau, this.row, sheet, mapStyle, false, rowLanguage);
        }
    }

    protected SQLRowAccessor getForeignRow(SQLRowAccessor row, SQLField field) {
        Map<Integer, SQLRowAccessor> c = this.cacheForeign.get(field.getName());
        int i = row.getInt(field.getName());
        if (c != null && c.get(i) != null) {
            return c.get(i);
        }
        SQLRowAccessor foreign = row.getForeign(field.getName());
        if (c == null) {
            HashMap<Integer, SQLRowAccessor> map = new HashMap<Integer, SQLRowAccessor>();
            map.put(i, foreign);
            this.cacheForeign.put(field.getName(), map);
        } else {
            c.put(i, foreign);
        }
        return foreign;
    }

    /*
     * WARNING - void declaration
     */
    private int fillTable(Element tableau, SQLRow row, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test, SQLRow rowLanguage) {
        void var17_28;
        if (tableau == null) {
            return 1;
        }
        int nbPage = 1;
        int nbCellules = 0;
        OOXMLTableElement tableElement = new OOXMLTableElement(tableau, row, this.rowRefCache);
        int currentLineTmp = tableElement.getFirstLine();
        int currentLine = tableElement.getFirstLine();
        SQLElement styleElt = Configuration.getInstance().getDirectory().getElement("STYLE");
        boolean cache = false;
        String ref = String.valueOf(tableau.getAttributeValue("table")) + "_" + row.getTable().getName() + row.getID();
        if (this.rowsEltCache.get(ref) == null) {
            this.rowsEltCache.put(ref, tableElement.getRows());
        } else {
            cache = true;
        }
        List listElts = tableau.getChildren("element");
        if (row.getTable().contains("ID_TAXE_PORT") && row.getTable().contains("PORT_HT")) {
            BigDecimal bigDecimal;
            SQLRowAccessor rowTaxe = this.getForeignRow(row, row.getTable().getField("ID_TAXE_PORT"));
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            if (row.getTable().getFieldRaw("PORT_HT") != null && (bigDecimal = new BigDecimal((Long)row.getObject("PORT_HT")).movePointLeft(2)).signum() != 0) {
                if (this.taxe.get(rowTaxe) != null) {
                    Object object = this.taxe.get(rowTaxe).get("MONTANT_HT");
                    BigDecimal montant = object == null ? BigDecimal.ZERO : (BigDecimal)object;
                    this.taxe.get(rowTaxe).put("MONTANT_HT", montant.add(bigDecimal));
                } else {
                    HashMap m = new HashMap();
                    m.put("MONTANT_HT", bigDecimal);
                    this.taxe.put(rowTaxe, m);
                }
            }
        }
        int numeroRef = 0;
        for (SQLRowAccessor sQLRowAccessor : this.rowsEltCache.get(ref)) {
            boolean included;
            ++numeroRef;
            if (!cache && sQLRowAccessor.getTable().getFieldRaw("ID_TAXE") != null) {
                SQLRowAccessor rowTaxe = this.getForeignRow(sQLRowAccessor, sQLRowAccessor.getTable().getField("ID_TAXE"));
                BigDecimal ht = BigDecimal.ZERO;
                if (sQLRowAccessor.getTable().getFieldRaw("T_PV_HT") != null) {
                    ht = (BigDecimal)sQLRowAccessor.getObject("T_PV_HT");
                }
                if (this.taxe.get(rowTaxe) != null) {
                    Object object = this.taxe.get(rowTaxe).get("MONTANT_HT");
                    BigDecimal montant = object == null ? BigDecimal.ZERO : (BigDecimal)object;
                    this.taxe.get(rowTaxe).put("MONTANT_HT", montant.add(ht));
                } else {
                    HashMap<String, BigDecimal> m = new HashMap<String, BigDecimal>();
                    m.put("MONTANT_HT", ht);
                    this.taxe.put(rowTaxe, m);
                }
            }
            if (!(included = OOgenerationXML.isIncluded(tableElement.getFilterId(), tableElement.getForeignTableWhere(), tableElement.getFilterId(), tableElement.getFieldWhere(), sQLRowAccessor)) && !tableElement.getTypeStyleWhere()) continue;
            String styleName = null;
            if (tableElement.getSQLElement().getTable().contains("ID_STYLE")) {
                styleName = styleElt.getTable().getRow(sQLRowAccessor.getInt("ID_STYLE")).getString("NOM");
            }
            if (included && tableElement.getTypeStyleWhere()) {
                styleName = "Titre 1";
            }
            if (!included) {
                styleName = "Normal";
            }
            boolean first = true;
            int toAdd = 0;
            if (styleName != null && tableElement.getListBlankLineStyle().contains(styleName) && first) {
                ++toAdd;
                ++currentLine;
                first = false;
            }
            HashMap<Element, Object> mapValues = new HashMap<Element, Object>();
            HashMap<String, Integer> tmpMapNbCel = new HashMap<String, Integer>();
            int tmpNbCellule = this.fillTableLine(sheet, mapStyle, true, rowLanguage, tableElement, currentLine, listElts, numeroRef, sQLRowAccessor, tmpMapNbCel, styleName, mapValues);
            for (String s : tmpMapNbCel.keySet()) {
                tmpNbCellule = Math.max(tmpNbCellule, (Integer)tmpMapNbCel.get(s));
            }
            if (currentLine + tmpNbCellule > tableElement.getEndPageLine() * nbPage) {
                toAdd += tableElement.getEndPageLine() * nbPage - currentLine;
                currentLineTmp = currentLine = currentLineTmp + tableElement.getEndPageLine();
                ++nbPage;
            }
            HashMap<String, Integer> mapNbCel = new HashMap<String, Integer>();
            int nbCellule = this.fillTableLine(sheet, mapStyle, test, rowLanguage, tableElement, currentLine, listElts, numeroRef, sQLRowAccessor, mapNbCel, styleName, mapValues);
            for (String s : mapNbCel.keySet()) {
                nbCellule = Math.max(nbCellule, (Integer)mapNbCel.get(s));
            }
            currentLine += nbCellule;
            nbCellules += nbCellule + toAdd;
        }
        int n = nbCellules / (tableElement.getEndPageLine() - tableElement.getFirstLine());
        int r = nbCellules % (tableElement.getEndPageLine() - tableElement.getFirstLine());
        if (n == 0) {
            void var17_24;
            ++var17_24;
            if (nbCellules > tableElement.getEndLine() - tableElement.getFirstLine() + 1) {
                void var17_25;
                ++var17_25;
            }
        } else if (r > tableElement.getEndLine() - tableElement.getFirstLine() + 1) {
            var17_26 += 2;
        } else {
            void var17_27;
            ++var17_27;
        }
        return (int)var17_28;
    }

    private int fillTableLine(Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test, SQLRow rowLanguage, OOXMLTableElement tableElement, int currentLine, List<Element> listElts, int numeroRef, SQLRowAccessor rowElt, Map<String, Integer> mapNbCel, String styleName, Map<Element, Object> mapValues) {
        int nbCellule = 1;
        int tableLine = 1;
        for (Element e : listElts) {
            OOXMLTableField tableField = new OOXMLTableField(e, rowElt, tableElement.getSQLElement(), rowElt.getID(), tableElement.getTypeStyleWhere() ? -1 : tableElement.getFilterId(), rowLanguage, numeroRef, this.rowRefCache);
            nbCellule = mapNbCel.get(e.getAttributeValue("location").trim()) != null ? mapNbCel.get(e.getAttributeValue("location").trim()) : 1;
            int line = tableField.getLine();
            if (tableField.getLine() > 1) {
                line = Math.max(nbCellule + (tableLine == tableField.getLine() ? 0 : 1), tableField.getLine());
            }
            tableLine = tableField.getLine();
            String loc = String.valueOf(e.getAttributeValue("location").trim()) + (currentLine + (line - 1));
            List<String> listBlankStyle = tableField.getBlankStyle();
            if (styleName == null || !listBlankStyle.contains(styleName)) {
                try {
                    Object value = mapValues.get(e);
                    if (value == null) {
                        value = tableField.getValue();
                        mapValues.put(e, value);
                    }
                    if (tableField.isNeeding2Lines() && tableField.getLine() == 1) {
                        loc = String.valueOf(e.getAttributeValue("location").trim()) + (currentLine + 1);
                        styleName = null;
                    }
                    Point resolveHint = sheet.resolveHint(loc);
                    if (test || sheet.isCellValid(resolveHint.x, resolveHint.y)) {
                        String styleNameTmp = styleName;
                        if (tableField.getStyle().trim().length() > 0) {
                            styleNameTmp = tableField.getStyle();
                        }
                        Map<Integer, String> mTmp = styleName == null ? null : mapStyle.get(styleNameTmp);
                        String styleOO = null;
                        if (mTmp != null) {
                            String oTmp = mTmp.get(resolveHint.x);
                            String string = styleOO = oTmp == null ? null : oTmp.toString();
                        }
                        if (tableField.isLineOption() && value != null && value.toString().trim().length() == 0) {
                            value = null;
                            styleOO = null;
                        }
                        int tmpCelluleAffect = this.fill(test ? "A1" : loc, value, sheet, tableField.isTypeReplace(), null, styleOO, test, tableField.isMultilineAuto());
                        if (tableField.getLine() != 1 && (!tableField.isLineOption() || value != null && value.toString().trim().length() > 0)) {
                            tmpCelluleAffect = nbCellule >= tableField.getLine() ? (tmpCelluleAffect += nbCellule) : (tmpCelluleAffect += tableField.getLine() - 1);
                        }
                        nbCellule = tableField.isNeeding2Lines() ? Math.max(nbCellule, 2) : Math.max(nbCellule, tmpCelluleAffect);
                    } else {
                        System.err.println("Cell not valid at " + loc);
                    }
                }
                catch (IndexOutOfBoundsException indexOut) {
                    System.err.println("Cell not valid at " + loc);
                }
            }
            mapNbCel.put(e.getAttributeValue("location").trim(), nbCellule);
        }
        return nbCellule;
    }

    private void fillTaxe(Element tableau, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test) {
        int line = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        List listElts = tableau.getChildren("element");
        for (SQLRowAccessor rowTaxe : this.taxe.keySet()) {
            Map<String, Object> m = this.taxe.get(rowTaxe);
            for (Element e : listElts) {
                String loc = String.valueOf(e.getAttributeValue("location").trim()) + line;
                String name = e.getAttributeValue("name");
                String typeComp = e.getAttributeValue("type");
                if (name == null) {
                    System.err.println("OOgenerationXML.fillTaxe() --> name == null");
                    continue;
                }
                Object value = m.get(name);
                if (name.equalsIgnoreCase("MONTANT_TVA")) {
                    value = ((BigDecimal)m.get("MONTANT_HT")).multiply(new BigDecimal(rowTaxe.getFloat("TAUX")), MathContext.DECIMAL128).movePointLeft(2);
                } else if (name.equalsIgnoreCase("NOM")) {
                    String suffix;
                    value = rowTaxe.getString("NOM");
                    String prefix = e.getAttributeValue("prefix");
                    if (prefix != null) {
                        value = String.valueOf(prefix) + value;
                    }
                    if ((suffix = e.getAttributeValue("suffix")) != null) {
                        value = String.valueOf(value) + suffix;
                    }
                }
                this.fill(test ? "A1" : loc, value, sheet, false, null, null, test, false);
            }
            ++line;
        }
    }

    private void parseElementsXML(List<Element> elts, SQLRow row, SpreadSheet spreadSheet) {
        SQLElement sqlElt = Configuration.getInstance().getDirectory().getElement(row.getTable());
        for (Element elt : elts) {
            OOXMLElement OOElt = new OOXMLElement(elt, sqlElt, row.getID(), row, null, this.rowRefCache);
            Object result = OOElt.getValue();
            if (result == null) continue;
            String o = elt.getAttributeValue("sheet");
            int sheet = o == null ? 0 : Integer.valueOf(o.toString().trim());
            this.fill(elt.getAttributeValue("location"), result, spreadSheet.getSheet(sheet), OOElt.isTypeReplace(), OOElt.getReplacePattern(), null, false, OOElt.isMultilineAuto());
        }
    }

    private static boolean isIncluded(int filterID, String foreignTable, int id, String fieldWhere, SQLRowAccessor rowElt) {
        if (filterID <= 1) {
            return true;
        }
        if (foreignTable != null) {
            boolean b = false;
            SQLTable table = Configuration.getInstance().getRoot().findTable(foreignTable);
            Collection<? extends SQLRowAccessor> set = rowElt.getReferentRows(table);
            for (SQLRowAccessor sQLRowAccessor : set) {
                boolean bl = b = b || sQLRowAccessor.getInt(fieldWhere) == filterID;
            }
            return b;
        }
        return filterID == id;
    }

    private int fill(String location, Object value, Sheet sheet, boolean replace, String replacePattern, String styleOO, boolean test, boolean controleMultiline) {
        int nbCellule;
        int n = nbCellule = test && styleOO == null ? 2 : 1;
        if (test || sheet.isCellValid(sheet.resolveHint((String)location).x, sheet.resolveHint((String)location).y)) {
            MutableCell cell = sheet.getCellAt(location);
            if (controleMultiline && value != null && value.toString().indexOf(10) >= 0) {
                String[] values = value.toString().split("\n");
                if (!test) {
                    Point p = sheet.resolveHint(location);
                    int y = 0;
                    String[] stringArray = values;
                    int n2 = values.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = stringArray[n3];
                        if (string != null && string.trim().length() != 0) {
                            try {
                                MutableCell c = sheet.getCellAt(p.x, p.y + y);
                                this.setCellValue(c, string, replace, replacePattern);
                                if (styleOO != null) {
                                    c.setStyleName(styleOO);
                                }
                                ++y;
                            }
                            catch (IllegalArgumentException e) {
                                ExceptionHandler.handle("La cellule " + location + " n'existe pas ou est fusionn\u00e9e.", e);
                            }
                        }
                        ++n3;
                    }
                }
                nbCellule = values.length;
            } else {
                nbCellule = 1;
                if (!test) {
                    this.setCellValue(cell, value, replace, replacePattern);
                    if (styleOO != null) {
                        cell.setStyleName(styleOO);
                    }
                }
            }
        }
        return nbCellule;
    }

    private void setCellValue(MutableCell cell, Object value, boolean replace, String replacePattern) {
        if (value == null) {
            return;
        }
        if (replace) {
            if (replacePattern != null) {
                cell.replaceBy(replacePattern, value.toString());
            } else {
                cell.replaceBy("_", value.toString());
            }
        } else {
            cell.setValue(value);
        }
    }

    private static File saveSpreadSheet(SpreadSheet ssheet, File pathDest, String fileName, String templateId, SQLRow rowLanguage) throws IOException {
        String langage;
        String string = langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
        if (ssheet == null || pathDest == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        File fDest = new File(pathDest, String.valueOf(fileName) + ".ods");
        if (!pathDest.exists()) {
            pathDest.mkdirs();
        }
        fDest = SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, pathDest, fDest);
        try {
            ssheet.saveAs(fDest);
        }
        catch (FileNotFoundException e) {
            final File file = fDest;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JOptionPane.showMessageDialog(null, "Le fichier " + file.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n V\u00e9rifiez qu'il n'est pas d\u00e9j\u00e0 ouvert.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            e.printStackTrace();
        }
        try {
            File odspOut = new File(pathDest, String.valueOf(fileName) + ".odsp");
            InputStream odspIn = TemplateManager.getInstance().getTemplatePrintConfiguration(templateId, langage, null);
            if (odspIn != null) {
                StreamUtils.copy(odspIn, odspOut);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Le fichier odsp n'existe pas.");
        }
        return fDest;
    }

    private Map<String, Map<Integer, String>> searchStyle(Sheet sheet, int colEnd, int rowEnd) {
        if (this.cacheStyle.get(sheet) != null) {
            return this.cacheStyle.get(sheet);
        }
        Map<String, Map<Integer, String>> mapStyleDef = StyleSQLElement.getMapAllStyle();
        int columnCount = colEnd == -1 ? sheet.getColumnCount() : colEnd + 1;
        System.err.println("End column search : " + columnCount);
        int rowCount = rowEnd > 0 ? rowEnd : sheet.getRowCount();
        System.err.println("End row search : " + rowCount);
        int i = 0;
        while (i < rowCount) {
            int x = 0;
            HashMap<Integer, String> mapCellStyle = new HashMap<Integer, String>();
            String style = "";
            int j = 0;
            while (j < columnCount) {
                block11: {
                    try {
                        if (!sheet.isCellValid(j, i)) break block11;
                        MutableCell c = sheet.getCellAt(j, i);
                        String cellStyle = c.getStyleName();
                        try {
                            if (mapStyleDef.containsKey(c.getValue().toString())) {
                                style = c.getValue().toString();
                            }
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        mapCellStyle.put(x, cellStyle);
                        if (style.trim().length() != 0) {
                            String styleCell;
                            c.clearValue();
                            if (!style.trim().equalsIgnoreCase("Normal") && mapStyleDef.get("Normal") != null && (styleCell = mapStyleDef.get("Normal").get(x)) != null && styleCell.length() != 0) {
                                c.setStyleName(styleCell);
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println("Index out of bounds Exception");
                    }
                }
                ++x;
                ++j;
            }
            if (style.length() > 0) {
                mapStyleDef.put(style, mapCellStyle);
            }
            ++i;
        }
        this.cacheStyle.put(sheet, mapStyleDef);
        return mapStyleDef;
    }

    public boolean needAnnexe(String templateId, String typeTemplate, SQLRow row, SQLRow rowLanguage) {
        Map<String, Map<Integer, String>> mapStyle;
        int nbPage;
        List listTable;
        SpreadSheet spreadSheet;
        block4: {
            String langage = rowLanguage != null ? rowLanguage.getString("CHEMIN") : null;
            SAXBuilder builder = new SAXBuilder();
            try {
                InputStream xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, langage, typeTemplate);
                Document doc = builder.build(xmlConfiguration);
                InputStream template = TemplateManager.getInstance().getTemplate(templateId, langage, typeTemplate);
                spreadSheet = new ODPackage(template).getSpreadSheet();
                Element racine = doc.getRootElement();
                listTable = racine.getChildren("table");
                if (listTable.size() != 0) break block4;
                return false;
            }
            catch (Throwable e) {
                Log.get().severe(e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        Element tableau = ((Element)listTable.get(0)).getAttributeValue("table").equalsIgnoreCase("TVA") ? (Element)listTable.get(1) : (Element)listTable.get(0);
        Sheet sheet = spreadSheet.getSheet(0);
        String oLastColTmp = tableau.getAttributeValue("lastColumn");
        int lastColumn = -1;
        int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        if (oLastColTmp != null) {
            lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
        }
        return (nbPage = this.fillTable(tableau, row, sheet, mapStyle = this.searchStyle(sheet, lastColumn, endPageLine), true, rowLanguage)) > 1;
    }
}

