/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLField;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class OOXMLElement {
    protected Element elt;
    protected SQLElement sqlElt;
    protected int id;
    protected SQLRowAccessor row;
    protected SQLRow rowLanguage;
    protected OOXMLCache cache;
    public static DateFormat format = new SimpleDateFormat("dd/MM/yyyy");

    public OOXMLElement(Element elt, SQLElement sqlElt, int id, SQLRow rowLanguage, OOXMLCache cache) {
        this(elt, sqlElt, id, null, rowLanguage, cache);
    }

    public OOXMLElement(Element elt, SQLElement sqlElt, int id, SQLRowAccessor row, SQLRow rowLanguage, OOXMLCache cache) {
        this.elt = elt;
        this.sqlElt = sqlElt;
        this.id = id;
        this.row = row;
        this.rowLanguage = rowLanguage;
        this.cache = cache;
    }

    public Object getValue() {
        Object res = "";
        String type = this.elt.getAttributeValue("type");
        SpreadSheetCellValueProvider provider = SpreadSheetCellValueProviderManager.get(type);
        if (provider != null) {
            SpreadSheetCellValueContext context = new SpreadSheetCellValueContext(this.row);
            List attrs = this.elt.getAttributes();
            for (Attribute attr : attrs) {
                context.put(attr.getName(), attr.getValue());
            }
            res = provider.getValue(context);
        } else if (type.equalsIgnoreCase("TotalHTTable")) {
            res = this.getTotalHTTable(this.row);
        } else {
            if (type.equalsIgnoreCase("sql.function")) {
                String field = this.elt.getAttributeValue("field");
                String table = this.elt.getAttributeValue("table");
                String function = this.elt.getAttributeValue("function");
                SQLTable referentTable = this.row.getTable().getTable(table);
                return this.getFromSQLFunction(referentTable.getField(field), function);
            }
            if (type.equalsIgnoreCase("DateEcheance")) {
                int idModeReglement = this.row.getInt("ID_MODE_REGLEMENT");
                Date d = (Date)this.row.getObject("DATE");
                res = this.getDateEcheance(idModeReglement, d, this.elt.getAttributeValue("datePattern"));
            } else {
                List eltFields = this.elt.getChildren("field");
                if (eltFields != null && !eltFields.isEmpty()) {
                    if (eltFields.size() > 1) {
                        String result = "";
                        for (Element eltField : eltFields) {
                            OOXMLField field = new OOXMLField(eltField, this.row, this.sqlElt, this.id, this.rowLanguage, this.cache);
                            Object value = field.getValue();
                            if (value == null) continue;
                            result = String.valueOf(result) + value.toString() + " ";
                        }
                        res = result;
                    } else {
                        OOXMLField field = new OOXMLField((Element)eltFields.get(0), this.row, this.sqlElt, this.id, this.rowLanguage, this.cache);
                        res = field.getValue();
                    }
                }
            }
        }
        ArrayList<String> listOfExcludedValues = null;
        List excludeValue = this.elt.getChildren("exclude");
        if (excludeValue != null && excludeValue.size() > 0) {
            listOfExcludedValues = new ArrayList<String>();
            for (Element element : excludeValue) {
                String attributeValue = element.getAttributeValue("value");
                listOfExcludedValues.add(attributeValue);
            }
        }
        if (res != null && listOfExcludedValues != null && listOfExcludedValues.contains(res.toString())) {
            res = null;
        }
        return res;
    }

    private Object getFromSQLFunction(SQLField field, String function) {
        SQLSelect sel = new SQLSelect();
        sel.addSelect(field, function);
        Where w = new Where((FieldRef)field.getTable().getField("ID_" + this.row.getTable().getName()), "=", this.row.getID());
        sel.setWhere(w);
        return Configuration.getInstance().getBase().getDataSource().executeScalar(sel.asString());
    }

    public Double getTotalHTTable(SQLRowAccessor rowFact) {
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection<? extends SQLRowAccessor> set = rowFact.getReferentRows(tableElt);
        long total = 0L;
        for (SQLRowAccessor sQLRowAccessor : set) {
            total += sQLRowAccessor.getLong("T_PV_HT");
        }
        return new Double(GestionDevise.currencyToString(total, false));
    }

    protected Object getDateEcheance(int idModeRegl, Date currentDate, String datePattern) {
        int nJ;
        SQLElement eltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
        SQLRow row = eltModeRegl.getTable().getRow(idModeRegl);
        int aJ = row.getInt("AJOURS");
        if (aJ + (nJ = row.getInt("LENJOUR")) == 0) {
            if (row.getBoolean("DATE_FACTURE").booleanValue()) {
                return Configuration.getInstance().getTranslator().getLabelFor(row.getTable().getField("DATE_FACTURE"));
            }
            return " ";
        }
        Date calculDate = ModeDeReglementSQLElement.calculDate(aJ, nJ, currentDate);
        if (datePattern != null && datePattern.trim().length() > 0) {
            SimpleDateFormat format2 = new SimpleDateFormat(datePattern);
            return format2.format(calculDate);
        }
        return calculDate;
    }

    public boolean isTypeReplace() {
        return this.elt.getAttributeValue("type").equalsIgnoreCase("Replace");
    }

    public String getReplacePattern() {
        return this.elt.getAttributeValue("replacePattern");
    }

    public boolean isMultilineAuto() {
        String multiLineValue = this.elt.getAttributeValue("controleMultiline");
        return multiLineValue == null ? true : !multiLineValue.equalsIgnoreCase("false");
    }
}

