/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class OOXMLCache {
    private Map<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>> cacheReferent = new HashMap<SQLRowAccessor, Map<SQLTable, List<SQLRowAccessor>>>();
    private Map<String, Map<Integer, SQLRowAccessor>> cacheForeign = new HashMap<String, Map<Integer, SQLRowAccessor>>();

    protected SQLRowAccessor getForeignRow(SQLRowAccessor row, SQLField field) {
        Map<Integer, SQLRowAccessor> c = this.cacheForeign.get(field.getName());
        if (row.getObject(field.getName()) == null) {
            return null;
        }
        int i = row.getInt(field.getName());
        if (c != null && c.get(i) != null) {
            return c.get(i);
        }
        SQLRowAccessor foreign = row.getForeign(field.getName());
        if (c == null) {
            HashMap<Integer, SQLRowAccessor> map = new HashMap<Integer, SQLRowAccessor>();
            map.put(i, foreign);
            this.cacheForeign.put(field.getName(), map);
        } else {
            c.put(i, foreign);
        }
        return foreign;
    }

    protected List<? extends SQLRowAccessor> getReferentRows(List<? extends SQLRowAccessor> row, SQLTable tableForeign, String groupBy) {
        ArrayList<? extends SQLRowAccessor> list;
        Map<SQLTable, List<SQLRowAccessor>> c = this.cacheReferent.get(row.get(0));
        if (c != null && c.get(tableForeign) != null) {
            System.err.println("get referent rows From Cache ");
            return c.get(tableForeign);
        }
        if (row.isEmpty() || row.size() > 0 && row.get(0).isUndefined()) {
            list = new ArrayList<SQLRowAccessor>();
        } else if (row.size() > 0 && (groupBy == null || groupBy.trim().length() == 0)) {
            list = new ArrayList();
            for (SQLRowAccessor sQLRowAccessor : row) {
                if (sQLRowAccessor == null || sQLRowAccessor.isUndefined()) continue;
                list.addAll(sQLRowAccessor.getReferentRows(tableForeign));
            }
        } else {
            List<String> list2 = SQLRow.toList(groupBy);
            SQLSelect sel = new SQLSelect(row.get(0).getTable().getBase());
            sel.addSelect(tableForeign.getKey());
            int i = 0;
            while (i < list2.size()) {
                sel.addSelect(tableForeign.getField(list2.get(i)));
                ++i;
            }
            Where w = null;
            for (SQLRowAccessor sQLRowAccessor : row) {
                w = w == null ? new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()) : w.or(new Where((FieldRef)((SQLField)tableForeign.getForeignKeys(sQLRowAccessor.getTable()).toArray()[0]), "=", sQLRowAccessor.getID()));
            }
            sel.setWhere(w);
            System.err.println(sel.asString());
            List list3 = (List)row.get(0).getTable().getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(tableForeign));
            list = new ArrayList();
            HashMap<Integer, SQLRowValues> m = new HashMap<Integer, SQLRowValues>();
            for (SQLRow sqlRow : list3) {
                SQLRowValues rowVals;
                Integer object = sqlRow.getInt(list2.get(0));
                if (m.get(object) == null || object == 1) {
                    rowVals = sqlRow.asRowValues();
                    m.put(object, rowVals);
                    list.add(rowVals);
                    continue;
                }
                rowVals = (SQLRowValues)m.get(object);
                this.cumulRows(list2, sqlRow, rowVals);
            }
        }
        if (c == null) {
            HashMap<SQLTable, ArrayList<? extends SQLRowAccessor>> hashMap = new HashMap<SQLTable, ArrayList<? extends SQLRowAccessor>>();
            hashMap.put(tableForeign, list);
            this.cacheReferent.put(row.get(0), hashMap);
        } else {
            c.put(tableForeign, list);
        }
        return list;
    }

    private void cumulRows(List<String> params, SQLRow sqlRow, SQLRowValues rowVals) {
        int i = 1;
        while (i < params.size()) {
            if (rowVals.getTable().getField(params.get(i)).getType().getJavaType() == String.class) {
                String string = sqlRow.getString(params.get(i));
                if (params.get(i).equalsIgnoreCase("NOM")) {
                    string = String.valueOf(sqlRow.getInt("QTE")) + " x " + string;
                }
                rowVals.put(params.get(i), String.valueOf(rowVals.getString(params.get(i))) + ", " + string);
            } else if (!rowVals.getTable().getField(params.get(i)).isKey()) {
                Long n = rowVals.getLong(params.get(i));
                rowVals.put(params.get(i), n + sqlRow.getLong(params.get(i)));
            }
            ++i;
        }
    }

    public void clearCache() {
        this.cacheReferent.clear();
        this.cacheForeign.clear();
    }
}

