/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.generationDoc.AbstractLocalTemplateProvider;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.sync.FileProperty;
import org.openconcerto.utils.sync.SyncClient;

public class DefaultCloudTemplateProvider
extends AbstractLocalTemplateProvider {
    private int idSociete;
    private static final String[] EXTS = new String[]{".ods", ".odsp", ".xml"};

    public DefaultCloudTemplateProvider(int idSociete) {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        this.idSociete = idSociete;
        if (!this.getCloudDir().exists()) {
            this.getCloudDir().mkdirs();
        }
        if (!this.getLocalDir().exists()) {
            this.getLocalDir().mkdirs();
        }
        SyncClient client = this.createSyncClient(config);
        String remotePath = "Template/" + idSociete;
        boolean remoteTemplateDirExists = false;
        try {
            System.out.println("DefaultCloudTemplateProvider: update template:" + this.getCloudDir().getCanonicalPath() + " from " + remotePath);
            ArrayList<FileProperty> list = client.getList(remotePath, config.getToken());
            System.out.println("DefaultCloudTemplateProvider: " + list.size() + " remote templates found in path: " + remotePath);
            remoteTemplateDirExists = true;
        }
        catch (Exception list) {
            // empty catch block
        }
        if (!remoteTemplateDirExists) {
            System.err.println("DefaultCloudTemplateProvider: No remote templates in path: " + remotePath);
            File defaultTemplateDir = new File("Configuration/Template/Default");
            try {
                if (this.getCloudDir().list().length <= 0) {
                    FileUtils.copyDirectory(defaultTemplateDir, this.getCloudDir());
                    FileUtils.copyDirectory(defaultTemplateDir, this.getLocalDir());
                }
            }
            catch (IOException e) {
                ExceptionHandler.handle("Impossible d'initialiser les mod\u00e8les", e);
            }
        } else {
            try {
                client.retrieveDirectory(this.getCloudDir(), remotePath, config.getToken());
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de synchroniser les mod\u00e8les", e);
            }
        }
    }

    private SyncClient createSyncClient(ComptaPropsConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("null configuration");
        }
        SyncClient client = new SyncClient("https://" + configuration.getStorageServer());
        client.setVerifyHost(false);
        return client;
    }

    @Override
    public File getTemplateFromLocalFile(String templateIdWithExtension, String language, String type) {
        if (templateIdWithExtension == null) {
            throw new NullPointerException("null templateIdWithExtension");
        }
        File f = this.getLocalFile(templateIdWithExtension, language, type);
        if (f == null || !f.exists()) {
            f = this.getCloudFile(templateIdWithExtension, language, type);
        }
        return f;
    }

    private File getLocalFile(String templateIdWithExtension, String language, String type) {
        String path = templateIdWithExtension;
        if (templateIdWithExtension == null) {
            throw new NullPointerException("null templateIdWithExtension");
        }
        if (type != null) {
            path = DefaultCloudTemplateProvider.insertBeforeExtenstion(path, type);
        }
        if (language != null && language.trim().length() > 0) {
            path = String.valueOf(language) + "/" + path;
        }
        if (path == null) {
            Log.get().info("null path for " + templateIdWithExtension + " " + language + " " + type);
            return null;
        }
        File dir = this.getLocalDir();
        File out = new File(dir, path);
        return out;
    }

    private File getCloudFile(String templateIdWithExtension, String language, String type) {
        String path = templateIdWithExtension;
        if (type != null) {
            path = DefaultCloudTemplateProvider.insertBeforeExtenstion(path, type);
        }
        if (language != null && language.trim().length() > 0) {
            path = String.valueOf(language) + "/" + path;
        }
        if (path == null) {
            Log.get().info("null path for " + templateIdWithExtension + " " + language + " " + type);
            return null;
        }
        File dir = this.getCloudDir();
        File out = new File(dir, path);
        return out;
    }

    private File getCloudDir() {
        return new File(ComptaPropsConfiguration.getInstance().getWD(), "OnCloud/Template/" + this.idSociete);
    }

    private File getLocalDir() {
        return new File(ComptaPropsConfiguration.getInstance().getWD(), "OnCloud/LocalTemplate/" + this.idSociete);
    }
}

