/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.supplychain.stock.element.ComposedItemStockUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.cc.ITransformer;

public class StockItemsUpdater {
    private final StockLabel label;
    private final List<? extends SQLRowAccessor> items;
    private final Type type;
    private final boolean createMouvementStock;
    private final SQLRowAccessor rowSource;
    List<String> requests = new ArrayList<String>();

    public StockItemsUpdater(StockLabel label, SQLRowAccessor rowSource, List<? extends SQLRowAccessor> items, Type t) {
        this(label, rowSource, items, t, true);
    }

    public StockItemsUpdater(StockLabel label, SQLRowAccessor rowSource, List<? extends SQLRowAccessor> items, Type t, boolean createMouvementStock) {
        this.label = label;
        this.items = items;
        this.type = t;
        this.createMouvementStock = createMouvementStock;
        this.rowSource = rowSource;
    }

    public void update() throws SQLException {
        SQLTable stockTable = this.rowSource.getTable().getTable("STOCK");
        if (this.createMouvementStock) {
            this.clearExistingMvt(this.rowSource);
        }
        List<StockItem> stockItems = this.fetch();
        for (StockItem stockItem : stockItems) {
            if (stockItem.isStockInit()) {
                this.requests.add(stockItem.getUpdateRequest());
                continue;
            }
            SQLRowValues rowVals = new SQLRowValues(stockTable);
            rowVals.put("QTE_REEL", stockItem.getRealQty());
            rowVals.put("QTE_TH", stockItem.getVirtualQty());
            rowVals.put("QTE_LIV_ATTENTE", stockItem.getDeliverQty());
            rowVals.put("QTE_RECEPT_ATTENTE", stockItem.getReceiptQty());
            SQLRowValues rowValsArt = stockItem.getArticle().createEmptyUpdateRow();
            rowValsArt.put("ID_STOCK", rowVals);
            rowValsArt.commit();
        }
        ArrayList<Object> handlers = new ArrayList<Object>(this.requests.size());
        for (String s : this.requests) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(stockTable.getDBSystemRoot(), this.requests, handlers);
        DBRoot root = this.rowSource.getTable().getDBRoot();
        if (root.contains("ARTICLE_ELEMENT")) {
            ComposedItemStockUpdater comp = new ComposedItemStockUpdater(root, stockItems);
            comp.update();
        }
    }

    private void clearExistingMvt(SQLRowAccessor rowSource) throws RTInterruptedException, SQLException {
        ArrayList<String> multipleRequests = new ArrayList<String>();
        final SQLTable table = this.rowSource.getTable().getTable("MOUVEMENT_STOCK");
        SQLRowValues rowVals = new SQLRowValues(table);
        rowVals.put("QTE", null);
        rowVals.put("REEL", null);
        SQLRowValues rowValsArt = new SQLRowValues(this.rowSource.getTable().getTable("ARTICLE"));
        SQLRowValues rowValsStock = new SQLRowValues(this.rowSource.getTable().getTable("STOCK"));
        rowValsStock.put("QTE_REEL", null);
        rowValsStock.put("QTE_TH", null);
        rowValsStock.put("QTE_RECEPT_ATTENTE", null);
        rowValsStock.put("QTE_LIV_ATTENTE", null);
        rowValsArt.put("ID_STOCK", rowValsStock);
        rowVals.put("ID_ARTICLE", rowValsArt);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)table.getField("SOURCE"), "=", (Object)StockItemsUpdater.this.rowSource.getTable().getName());
                w = w.and(new Where((FieldRef)table.getField("IDSOURCE"), "=", StockItemsUpdater.this.rowSource.getID()));
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> result = fetcher.fetch();
        for (SQLRowValues sqlRowValues : result) {
            StockItem item = new StockItem(sqlRowValues.getForeign("ID_ARTICLE"));
            StockItem.Type t = sqlRowValues.getBoolean("REEL") != false ? StockItem.Type.REEL : StockItem.Type.THEORIQUE;
            item.updateQty(sqlRowValues.getFloat("QTE"), t, true);
            String req = "UPDATE " + sqlRowValues.getTable().getSQLName().quote() + " SET \"ARCHIVE\"=1 WHERE \"ID\"=" + sqlRowValues.getID();
            multipleRequests.add(req);
            multipleRequests.add(item.getUpdateRequest());
        }
        ArrayList<Object> handlers = new ArrayList<Object>(multipleRequests.size());
        for (String s : multipleRequests) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(table.getDBSystemRoot(), multipleRequests, handlers);
    }

    private List<StockItem> fetch() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<StockItem> stockItems = new ArrayList<StockItem>(this.items.size());
        StockItem.Type stockItemType = this.type.isVirtual() ? StockItem.Type.THEORIQUE : StockItem.Type.REEL;
        for (SQLRowAccessor sQLRowAccessor : this.items) {
            SQLRowAccessor article;
            if (sQLRowAccessor.isForeignEmpty("ID_ARTICLE") || !(article = sQLRowAccessor.getForeign("ID_ARTICLE")).getBoolean("GESTION_STOCK").booleanValue()) continue;
            StockItem stockItem = new StockItem(article);
            int qte = sQLRowAccessor.getInt("QTE");
            BigDecimal qteUV = sQLRowAccessor.getBigDecimal("QTE_UNITAIRE");
            double qteFinal = qteUV.multiply(new BigDecimal(qte), MathContext.DECIMAL128).doubleValue();
            if (!this.type.isEntry()) {
                qteFinal = -qteFinal;
            }
            stockItem.updateQty(qteFinal, stockItemType);
            stockItems.add(stockItem);
            if (!this.createMouvementStock) continue;
            String mvtStockQuery = "INSERT INTO " + article.getTable().getTable("MOUVEMENT_STOCK").getSQLName().quote() + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"SOURCE\",\"IDSOURCE\",\"NOM\",\"REEL\") VALUES(" + qteFinal + ",'" + dateFormat.format(this.rowSource.getDate("DATE").getTime()) + "'," + article.getID() + ",'" + this.rowSource.getTable().getName() + "'," + this.rowSource.getID() + ",'" + this.label.getLabel(this.rowSource, sQLRowAccessor) + "'," + String.valueOf(!this.type.isVirtual()) + ")";
            this.requests.add(mvtStockQuery);
        }
        return stockItems;
    }

    public static enum Type {
        VIRTUAL_RECEPT(true, true),
        REAL_RECEPT(true, false),
        VIRTUAL_DELIVER(false, true),
        REAL_DELIVER(false, false);

        private boolean entry;
        private boolean virtual;

        private Type(boolean entry, boolean virtual) {
            this.entry = entry;
            this.virtual = virtual;
        }

        public boolean isEntry() {
            return this.entry;
        }

        public boolean isVirtual() {
            return this.virtual;
        }
    }
}

