/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;

public class StockItem {
    private double realQty;
    private double virtualQty;
    private double receiptQty;
    private double deliverQty;
    public SQLRowAccessor article;
    List<StockItemComponent> components = new ArrayList<StockItemComponent>();

    public StockItem(SQLRowAccessor article) {
        this.article = article;
        if (this.article.isForeignEmpty("ID_STOCK")) {
            this.realQty = 0.0;
            this.virtualQty = 0.0;
            this.receiptQty = 0.0;
            this.deliverQty = 0.0;
        } else {
            SQLRowAccessor row = this.article.getForeign("ID_STOCK");
            this.realQty = row.getFloat("QTE_REEL");
            this.virtualQty = row.getFloat("QTE_TH");
            this.receiptQty = row.getFloat("QTE_RECEPT_ATTENTE");
            this.deliverQty = row.getFloat("QTE_LIV_ATTENTE");
        }
    }

    public void updateQty(double qty, Type t) {
        this.updateQty(qty, t, false);
    }

    public SQLRowAccessor getArticle() {
        return this.article;
    }

    public void addItemComponent(StockItemComponent item) {
        this.components.add(item);
    }

    public void updateQtyFromChildren() throws IllegalArgumentException {
        if (this.components.size() == 0) {
            throw new IllegalArgumentException("Impossible de calcul\u00e9 les quantit\u00e9s depuis les composants. Cet article n'est pas compos\u00e9!");
        }
        StockItemComponent comp = this.components.get(0);
        double real = comp.getItem().getRealQty() == 0.0 ? 0.0 : Math.ceil(comp.getItem().getRealQty() / ((double)comp.getQty() * comp.getQtyUnit().doubleValue()));
        double virtual = comp.getItem().getVirtualQty() == 0.0 ? 0.0 : Math.ceil(comp.getItem().getVirtualQty() / ((double)comp.getQty() * comp.getQtyUnit().doubleValue()));
        for (StockItemComponent stockItemComponent : this.components) {
            real = Math.min(real, stockItemComponent.getItem().getRealQty() == 0.0 ? 0.0 : Math.ceil(stockItemComponent.getItem().getRealQty() / ((double)stockItemComponent.getQty() * stockItemComponent.getQtyUnit().doubleValue())));
            virtual = Math.min(virtual, stockItemComponent.getItem().getVirtualQty() == 0.0 ? 0.0 : Math.ceil(stockItemComponent.getItem().getVirtualQty() / ((double)stockItemComponent.getQty() * stockItemComponent.getQtyUnit().doubleValue())));
        }
        this.realQty = real;
        this.virtualQty = virtual;
    }

    public void updateQty(double qty, Type t, boolean archive) {
        if (t == Type.REEL) {
            double qteNvlle;
            double qteOrigin = this.realQty;
            if (archive) {
                qteNvlle = qteOrigin - qty;
                if (qty > 0.0) {
                    this.receiptQty += qty;
                } else {
                    this.deliverQty -= qty;
                }
            } else {
                qteNvlle = qteOrigin + qty;
                if (qty > 0.0) {
                    this.receiptQty -= qty;
                } else {
                    this.deliverQty += qty;
                }
            }
            this.realQty = qteNvlle;
        } else {
            double qteNvlle;
            double qteOrigin = this.virtualQty;
            if (archive) {
                qteNvlle = qteOrigin - qty;
                if (qty > 0.0) {
                    this.receiptQty -= qty;
                } else {
                    this.deliverQty += qty;
                }
            } else {
                qteNvlle = qteOrigin + qty;
                if (qty > 0.0) {
                    this.receiptQty += qty;
                } else {
                    this.deliverQty -= qty;
                }
            }
            this.virtualQty = qteNvlle;
        }
    }

    public double getDeliverQty() {
        return this.deliverQty;
    }

    public double getRealQty() {
        return this.realQty;
    }

    public double getReceiptQty() {
        return this.receiptQty;
    }

    public double getVirtualQty() {
        return this.virtualQty;
    }

    public boolean isStockInit() {
        return !this.article.isForeignEmpty("ID_STOCK");
    }

    public String getUpdateRequest() {
        SQLTable stockTable = this.article.getTable().getForeignTable("ID_STOCK");
        UpdateBuilder update = new UpdateBuilder(stockTable);
        update.setWhere(new Where((FieldRef)stockTable.getKey(), "=", this.getArticle().getForeign("ID_STOCK").getID()));
        update.setObject("QTE_REEL", (Object)this.getRealQty());
        update.setObject("QTE_TH", (Object)this.getVirtualQty());
        update.setObject("QTE_LIV_ATTENTE", (Object)this.getDeliverQty());
        update.setObject("QTE_RECEPT_ATTENTE", (Object)this.getReceiptQty());
        return update.asString();
    }

    public static enum Type {
        REEL,
        THEORIQUE;

    }
}

