/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.cc.ITransformer;

public class ComposedItemStockUpdater {
    private final List<StockItem> itemsUpdated;
    private final DBRoot root;

    public ComposedItemStockUpdater(DBRoot root, List<StockItem> itemsUpdated) {
        this.itemsUpdated = itemsUpdated;
        this.root = root;
    }

    public void update() throws SQLException {
        List<StockItem> items = this.getAllComposedItemToUpdate();
        this.getAllChildren(items);
        for (StockItem stockItem : items) {
            stockItem.updateQtyFromChildren();
        }
        SQLTable stockTable = this.root.getTable("STOCK");
        ArrayList<String> requests = new ArrayList<String>();
        for (StockItem stockItem : items) {
            if (stockItem.isStockInit()) {
                UpdateBuilder update = new UpdateBuilder(stockTable);
                update.setWhere(new Where((FieldRef)stockTable.getKey(), "=", stockItem.getArticle().getForeign("ID_STOCK").getID()));
                update.setObject("QTE_REEL", (Object)stockItem.getRealQty());
                update.setObject("QTE_TH", (Object)stockItem.getVirtualQty());
                update.setObject("QTE_LIV_ATTENTE", (Object)stockItem.getDeliverQty());
                update.setObject("QTE_RECEPT_ATTENTE", (Object)stockItem.getReceiptQty());
                requests.add(update.asString());
                continue;
            }
            SQLRowValues rowVals = new SQLRowValues(stockTable);
            rowVals.put("QTE_REEL", stockItem.getRealQty());
            rowVals.put("QTE_TH", stockItem.getVirtualQty());
            rowVals.put("QTE_LIV_ATTENTE", stockItem.getDeliverQty());
            rowVals.put("QTE_RECEPT_ATTENTE", stockItem.getReceiptQty());
            SQLRowValues rowValsArt = stockItem.getArticle().createEmptyUpdateRow();
            rowValsArt.put("ID_STOCK", rowVals);
            rowValsArt.commit();
        }
        ArrayList<Object> handlers = new ArrayList<Object>(requests.size());
        for (String s : requests) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(stockTable.getDBSystemRoot(), requests, handlers);
    }

    private void getAllChildren(List<StockItem> items) {
        SQLTable tableArticle = this.root.getTable("ARTICLE");
        SQLRowValues rowValsArt = new SQLRowValues(tableArticle);
        rowValsArt.put(tableArticle.getKey().getName(), null);
        SQLRowValues rowValsStock = new SQLRowValues(tableArticle.getForeignTable("ID_STOCK"));
        rowValsStock.put("QTE_REEL", null);
        rowValsStock.put("QTE_TH", null);
        rowValsStock.put("QTE_RECEPT_ATTENTE", null);
        rowValsStock.put("QTE_LIV_ATTENTE", null);
        rowValsArt.put("ID_STOCK", rowValsStock);
        final SQLTable tableArticleElt = this.root.getTable("ARTICLE_ELEMENT");
        SQLRowValues rowValsArtItem = new SQLRowValues(tableArticleElt);
        rowValsArtItem.put("ID_ARTICLE", rowValsArt);
        rowValsArtItem.put("QTE", null);
        rowValsArtItem.put("QTE_UNITAIRE", null);
        rowValsArtItem.put("ID_ARTICLE_PARENT", null);
        final ArrayList<Integer> ids = new ArrayList<Integer>();
        HashMap<Integer, StockItem> mapItem = new HashMap<Integer, StockItem>();
        for (StockItem stockItem : items) {
            int id = stockItem.getArticle().getID();
            ids.add(id);
            mapItem.put(id, stockItem);
        }
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsArtItem);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where(tableArticleElt.getField("ID_ARTICLE_PARENT"), ids);
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> values = fetcher.fetch();
        for (SQLRowValues sqlRowValues : values) {
            SQLRowAccessor article = sqlRowValues.getForeign("ID_ARTICLE");
            SQLRowAccessor articleParent = sqlRowValues.getForeign("ID_ARTICLE_PARENT");
            ((StockItem)mapItem.get(articleParent.getID())).addItemComponent(new StockItemComponent(new StockItem(article), sqlRowValues.getBigDecimal("QTE_UNITAIRE"), sqlRowValues.getInt("QTE")));
        }
    }

    private List<StockItem> getAllComposedItemToUpdate() {
        ArrayList<Integer> ids = new ArrayList<Integer>(this.itemsUpdated.size());
        for (StockItem stockItem : this.itemsUpdated) {
            ids.add(stockItem.getArticle().getID());
        }
        List<SQLRowValues> list = this.getComposedItemToUpdate(ids);
        int size = list.size();
        while (size > 0) {
            List<SQLRowValues> l = this.getComposedItemToUpdate(ids);
            list.removeAll(l);
            list.addAll(l);
            size = l.size();
            if (size <= 0) continue;
            ids.clear();
            for (SQLRowValues r : l) {
                ids.add(r.getID());
            }
        }
        ArrayList<StockItem> items = new ArrayList<StockItem>(list.size());
        for (SQLRowValues rowVals : list) {
            StockItem item = new StockItem(rowVals);
            items.add(item);
        }
        return items;
    }

    private List<SQLRowValues> getComposedItemToUpdate(final List<Integer> ids) {
        SQLTable tableArticle = this.root.getTable("ARTICLE");
        SQLRowValues rowValsArt = new SQLRowValues(tableArticle);
        rowValsArt.put(tableArticle.getKey().getName(), null);
        SQLRowValues rowValsStock = new SQLRowValues(tableArticle.getForeignTable("ID_STOCK"));
        rowValsStock.put("QTE_REEL", null);
        rowValsStock.put("QTE_TH", null);
        rowValsStock.put("QTE_RECEPT_ATTENTE", null);
        rowValsStock.put("QTE_LIV_ATTENTE", null);
        rowValsArt.put("ID_STOCK", rowValsStock);
        final SQLTable tableArticleElt = this.root.getTable("ARTICLE_ELEMENT");
        SQLRowValues rowValsArtItem = new SQLRowValues(tableArticleElt);
        rowValsArtItem.put("ID_ARTICLE_PARENT", rowValsArt);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsArt);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect input) {
                SQLSelectJoin joinFromField = input.getJoinFromField(tableArticleElt.getField("ID_ARTICLE_PARENT"));
                Where w = new Where(joinFromField.getJoinedTable().getField("ID_ARTICLE"), ids);
                joinFromField.setWhere(w);
                Where w2 = new Where(joinFromField.getJoinedTable().getKey(), "is not", (Object)null);
                input.setWhere(w2);
                return input;
            }
        });
        return fetcher.fetch();
    }
}

