/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.supplychain.order.element.CommandeSQLElement;
import org.openconcerto.erp.core.supplychain.order.ui.CommandeItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationDoc.gestcomm.CommandeXmlSheet;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.AutoHideListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ExceptionHandler;

public class CommandeSQLComponent
extends TransfertBaseSQLComponent {
    private CommandeItemTable table = new CommandeItemTable();
    private JUniqueTextField numeroUniqueCommande;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final JCheckBox checkImpression = new JCheckBox("Imprimer");
    private final JCheckBox checkVisu = new JCheckBox("Visualiser");
    private final ITextArea infos = new ITextArea(3, 3);
    private ElementComboBox fourn = new ElementComboBox();
    final JCheckBox boxLivrClient = new JCheckBox("Livrer directement le client");
    private DefaultElementSQLObject compAdr;
    final JPanel panelAdrSpec = new JPanel(new GridBagLayout());

    public CommandeSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("COMMANDE"));
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        this.numeroUniqueCommande = new JUniqueTextField(16);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.numeroUniqueCommande);
        this.add((Component)this.numeroUniqueCommande, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)labelDate, c);
        JDate dateCommande = new JDate(true);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)((Object)dateCommande), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_FOURNISSEUR"), 4), c);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.fourn, c);
        if (!this.getTable().getFieldsName().contains("LIVRER")) {
            JCheckBox boxEnCours = new JCheckBox(this.getLabelFor("EN_COURS"));
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 2;
            c.gridwidth = 0;
            this.add((Component)boxEnCours, c);
            c.gridwidth = 1;
            this.addRequiredSQLObject(boxEnCours, "EN_COURS");
        }
        if (this.getTable().contains("ID_CONTACT_FOURNISSEUR")) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_CONTACT_FOURNISSEUR"), 4), c);
            c.gridx = -1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            final ElementComboBox boxContactFournisseur = new ElementComboBox();
            final SQLElement contactElement = Configuration.getInstance().getDirectory().getElement("CONTACT_FOURNISSEUR");
            boxContactFournisseur.init(contactElement, contactElement.getComboRequest(true));
            this.add((Component)boxContactFournisseur, c);
            this.addView(boxContactFournisseur, "ID_CONTACT_FOURNISSEUR", (Object)"required");
            this.fourn.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (CommandeSQLComponent.this.fourn.getSelectedRow() != null) {
                        boxContactFournisseur.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_FOURNISSEUR"), "=", CommandeSQLComponent.this.fourn.getSelectedRow().getID()));
                    } else {
                        boxContactFournisseur.getRequest().setWhere(null);
                    }
                }
            });
        }
        if (this.getTable().getFieldsName().contains("ID_ADRESSE")) {
            if (this.getTable().getFieldsName().contains("LIVRAISON_F")) {
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.fill = 2;
                this.add((Component)new JLabel(this.getLabelFor("ID_ADRESSE")), c);
                ++c.gridx;
                c.gridwidth = 0;
                this.addView("ID_ADRESSE");
                final DefaultElementSQLObject comp = (DefaultElementSQLObject)this.getView("ID_ADRESSE").getComp();
                if (this.getTable().getFieldsName().contains("LIVRAISON_F")) {
                    final JCheckBox boxLivr = new JCheckBox("Livr\u00e9 par le fournisseur");
                    this.add((Component)boxLivr, c);
                    this.addSQLObject(boxLivr, "LIVRAISON_F");
                    boxLivr.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (boxLivr.isSelected() && !comp.isCreated()) {
                                comp.setCreated(true);
                                if (CommandeSQLComponent.this.getTable().contains("ID_AFFAIRE")) {
                                    SQLRowValues rowVals = CommandeSQLComponent.this.getLivraisonAdr(((ElementComboBox)CommandeSQLComponent.this.getView("ID_AFFAIRE").getComp()).getSelectedRow());
                                    comp.setValue(rowVals);
                                }
                            } else if (!boxLivr.isSelected()) {
                                comp.setCreated(false);
                            }
                        }
                    });
                }
                ++c.gridy;
                this.add((Component)comp, c);
                this.add(this.getView("ID_ADRESSE").getComp(), c);
            } else {
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)new JLabel("Livraison"), c);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)this.boxLivrClient, c);
                c.gridwidth = 1;
                DefaultGridBagConstraints cAdr = new DefaultGridBagConstraints();
                this.panelAdrSpec.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), cAdr);
                final ElementComboBox boxClient = new ElementComboBox(true);
                cAdr.weightx = 1.0;
                ++cAdr.gridx;
                this.panelAdrSpec.add((Component)boxClient, cAdr);
                this.addView(boxClient, "ID_CLIENT");
                ++cAdr.gridy;
                cAdr.weightx = 0.0;
                cAdr.gridx = 0;
                this.panelAdrSpec.add((Component)new JLabel("Adresse", 4), cAdr);
                final SQLRequestComboBox boxAdr = new SQLRequestComboBox(true);
                boxAdr.uiInit(Configuration.getInstance().getDirectory().getElement(this.getTable().getTable("ADRESSE")).getComboRequest(true));
                boxClient.addModelListener("wantedID", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (boxClient.getSelectedRow() != null && !boxClient.getSelectedRow().isUndefined()) {
                            Where w = new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", boxClient.getSelectedRow().getID());
                            w = w.or(new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getKey(), "=", boxClient.getSelectedRow().getInt("ID_ADRESSE")));
                            w = w.or(new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getKey(), "=", boxClient.getSelectedRow().getInt("ID_ADRESSE_F")));
                            w = w.or(new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getKey(), "=", boxClient.getSelectedRow().getInt("ID_ADRESSE_L")));
                            boxAdr.getRequest().setWhere(w);
                        } else {
                            boxAdr.getRequest().setWhere(null);
                        }
                    }
                });
                cAdr.weightx = 1.0;
                ++cAdr.gridx;
                this.panelAdrSpec.add((Component)boxAdr, cAdr);
                cAdr.gridx = 0;
                ++cAdr.gridy;
                cAdr.weightx = 0.0;
                if (this.getMode() == SQLComponent.Mode.MODIFICATION) {
                    this.panelAdrSpec.add((Component)new JLabel(this.getLabelFor("ID_ADRESSE")), cAdr);
                }
                ++cAdr.gridx;
                cAdr.gridwidth = 0;
                this.addView("ID_ADRESSE");
                this.compAdr = (DefaultElementSQLObject)this.getView("ID_ADRESSE").getComp();
                ++cAdr.gridy;
                if (this.getMode() == SQLComponent.Mode.MODIFICATION) {
                    this.panelAdrSpec.add((Component)this.compAdr, cAdr);
                }
                boxAdr.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SQLRow row = boxAdr.getSelectedRow();
                        if (row != null && !row.isUndefined()) {
                            CommandeSQLComponent.this.compAdr.setCreated(true);
                            SQLRowValues asRowValues = new SQLRowValues(row.asRowValues());
                            CommandeSQLComponent.this.compAdr.setValue(asRowValues);
                        }
                    }
                });
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 0;
                c.weightx = 1.0;
                this.add((Component)this.panelAdrSpec, c);
                c.gridwidth = 1;
                c.weightx = 0.0;
                this.boxLivrClient.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CommandeSQLComponent.this.panelAdrSpec.setVisible(CommandeSQLComponent.this.boxLivrClient.isSelected());
                        if (!CommandeSQLComponent.this.boxLivrClient.isSelected()) {
                            boxClient.setValue((Integer)null);
                            boxAdr.setValue((Integer)null);
                            CommandeSQLComponent.this.compAdr.setCreated(false);
                        }
                    }
                });
                this.panelAdrSpec.setVisible(false);
            }
        }
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        final ElementComboBox boxDevise = new ElementComboBox();
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_DEVISE"), 4), c);
            c.gridx = -1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)boxDevise, c);
            this.addView(boxDevise, "ID_DEVISE");
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 13;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        JTextField textNom = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textNom, c);
        String field = "ID_COMMERCIAL";
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)new JLabel(this.getLabelFor(field), 4), c);
        ElementComboBox commSel = new ElementComboBox(false, 25);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)commSel, c);
        this.addRequiredSQLObject(commSel, field);
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        this.add((Component)this.table, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            boxDevise.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CommandeSQLComponent.this.table.setDevise(boxDevise.getSelectedRow());
                }
            });
        }
        this.fourn.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CommandeSQLComponent.this.table.setFournisseur(CommandeSQLComponent.this.fourn.getSelectedRow());
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.getBottomPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.anchor = 17;
        JPanel panelOO = new JPanel(new FlowLayout(2));
        panelOO.add((Component)this.checkImpression, c);
        panelOO.add((Component)this.checkVisu, c);
        c.gridwidth = 0;
        this.add((Component)panelOO, c);
        this.addRequiredSQLObject(this.fourn, "ID_FOURNISSEUR");
        this.addSQLObject(textNom, "NOM");
        this.addRequiredSQLObject((JComponent)((Object)dateCommande), "DATE");
        this.addRequiredSQLObject(this.numeroUniqueCommande, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(CommandeSQLElement.class));
        DefaultGridBagConstraints.lockMinimumSize(this.fourn);
        DefaultGridBagConstraints.lockMinimumSize(commSel);
    }

    protected SQLRowValues getLivraisonAdr(SQLRow rowAffaire) {
        if (rowAffaire != null) {
            SQLRow rowClient = rowAffaire.getForeignRow("ID_CLIENT");
            SQLRow rowAdrL = rowClient.getForeignRow("ID_ADRESSE_L");
            if (rowAdrL == null || rowAdrL.isUndefined()) {
                rowAdrL = rowClient.getForeignRow("ID_ADRESSE");
            }
            SQLRowValues rowVals = rowAdrL.asRowValues();
            rowVals.clearPrimaryKeys();
            return rowVals;
        }
        return new SQLRowValues(this.getTable().getTable("ADRESSE"));
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        panel.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, c);
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        final JTextField textPoidsTotal = new JTextField(8);
        JTextField poids = new JTextField();
        if (b.booleanValue()) {
            JPanel panelPoids = new JPanel();
            panelPoids.add((Component)new JLabel(this.getLabelFor("T_POIDS")), c);
            textPoidsTotal.setEnabled(false);
            textPoidsTotal.setHorizontalAlignment(4);
            textPoidsTotal.setDisabledTextColor(Color.BLACK);
            panelPoids.add((Component)textPoidsTotal, c);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
            this.addSQLObject(textPoidsTotal, "T_POIDS");
        } else {
            this.addSQLObject(poids, "T_POIDS");
        }
        DeviseField textPortHT = new DeviseField();
        ElementComboBox comboTaxePort = new ElementComboBox();
        if (this.getTable().contains("PORT_HT")) {
            this.addRequiredSQLObject(textPortHT, "PORT_HT");
            JPanel panelPoids = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints cPort = new DefaultGridBagConstraints();
            cPort.gridx = 0;
            cPort.weightx = 0.0;
            panelPoids.add((Component)new JLabel(this.getLabelFor("PORT_HT")), cPort);
            textPortHT.setHorizontalAlignment(4);
            ++cPort.gridx;
            cPort.weightx = 1.0;
            panelPoids.add((Component)textPortHT, cPort);
            ++cPort.gridy;
            cPort.gridx = 0;
            cPort.weightx = 0.0;
            this.addRequiredSQLObject(comboTaxePort, "ID_TAXE_PORT");
            panelPoids.add((Component)new JLabel(this.getLabelFor("ID_TAXE_PORT")), cPort);
            ++cPort.gridx;
            cPort.weightx = 0.0;
            panelPoids.add((Component)comboTaxePort, cPort);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
        }
        DeviseField textRemiseHT = new DeviseField();
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        fieldHT.setOpaque(false);
        fieldTVA.setOpaque(false);
        fieldTTC.setOpaque(false);
        fieldService.setOpaque(false);
        this.addRequiredSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        final TotalPanel totalTTC = new TotalPanel(this.table, fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, null, fieldDevise, null, null, this.getTable().contains("ID_TAXE_PORT") ? comboTaxePort : null);
        ++c.gridx;
        --c.gridy;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.anchor = 12;
        c.fill = 1;
        c.weighty = 0.0;
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        panel.add((Component)totalTTC, c);
        c.gridy += 3;
        c.gridheight = 2;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)this.getModuleTotalPanel(), c);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                textPoidsTotal.setText(String.valueOf(CommandeSQLComponent.this.table.getPoidsTotal()));
            }
        });
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        comboTaxePort.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        return panel;
    }

    protected JPanel getModuleTotalPanel() {
        return AutoHideListener.listen(new JPanel());
    }

    @Override
    public int insert(SQLRow order) {
        int idCommande = this.getSelectedID();
        if (this.numeroUniqueCommande.checkValidation()) {
            idCommande = super.insert(order);
            this.table.updateField("ID_COMMANDE", idCommande);
            this.table.createArticle(idCommande, this.getElement());
            try {
                this.updateStock(idCommande);
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du stock!", e);
            }
            CommandeXmlSheet sheet = new CommandeXmlSheet(this.getTable().getRow(idCommande));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.checkVisu.isSelected(), this.checkImpression.isSelected(), true);
            if (NumerotationAutoSQLElement.getNextNumero(CommandeSQLElement.class).equalsIgnoreCase(this.numeroUniqueCommande.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt(NumerotationAutoSQLElement.getLabelNumberFor(CommandeSQLElement.class));
                rowVals.put(NumerotationAutoSQLElement.getLabelNumberFor(CommandeSQLElement.class), new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idCommande;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            this.numeroUniqueCommande.setIdSelected(r.getID());
        }
        if (!this.getTable().contains("LIVRAISON_F") && r != null && !r.isUndefined()) {
            SQLRowAccessor adr = r.getForeign("ID_ADRESSE");
            this.boxLivrClient.setSelected(adr != null && !adr.isUndefined());
            this.panelAdrSpec.setVisible(this.boxLivrClient.isSelected());
            if (!this.boxLivrClient.isSelected()) {
                this.compAdr.setCreated(false);
            }
        }
        super.select(r);
        if (r != null) {
            this.table.insertFrom("ID_COMMANDE", r.getID());
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueCommande.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        final int id = this.getSelectedID();
        this.table.updateField("ID_COMMANDE", id);
        this.table.createArticle(id, this.getElement());
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SQLRow row = CommandeSQLComponent.this.getTable().getRow(id);
                    SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
                    SQLSelect sel = new SQLSelect();
                    sel.addSelect(eltMvtStock.getTable().getField("ID"));
                    Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
                    Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)CommandeSQLComponent.this.getTable().getName());
                    sel.setWhere(w.and(w2));
                    List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
                    if (l != null) {
                        int i = 0;
                        while (i < l.size()) {
                            Object[] tmp = (Object[])l.get(i);
                            eltMvtStock.archive(((Number)tmp[0]).intValue());
                            ++i;
                        }
                    }
                    CommandeSQLComponent.this.updateStock(id);
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Update error", e);
                }
            }
        });
        CommandeXmlSheet sheet = new CommandeXmlSheet(this.getTable().getRow(id));
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(this.checkVisu.isSelected(), this.checkImpression.isSelected(), true);
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "Commande fournisseur N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLRow row = this.getTable().getRow(id);
        StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

            @Override
            public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                return CommandeSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
            }
        }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("COMMANDE_ELEMENT")), StockItemsUpdater.Type.REAL_RECEPT);
        stockUpdater.update();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("T_POIDS", Float.valueOf(0.0f));
        rowVals.put("EN_COURS", Boolean.TRUE);
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        rowVals.put("T_HT", 0L);
        rowVals.put("T_SERVICE", 0L);
        rowVals.put("T_DEVISE", 0L);
        rowVals.put("T_TVA", 0L);
        rowVals.put("T_TTC", 0L);
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(CommandeSQLElement.class));
        if (this.getTable().contains("ID_TAXE_PORT")) {
            rowVals.put("ID_TAXE_PORT", TaxeCache.getCache().getFirstTaxe().getID());
        }
        return rowVals;
    }

    @Override
    public RowValuesTable getRowValuesTable() {
        return this.table.getRowValuesTable();
    }
}

