/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.element;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.quote.component.DevisSQLComponent;
import org.openconcerto.erp.core.sales.quote.element.DevisItemSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.sales.quote.ui.QuoteEditGroup;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;

public class DevisSQLElement
extends ComptaSQLConfElement {
    public DevisSQLElement() {
        this("un devis", "devis");
    }

    public DevisSQLElement(String singular, String plural) {
        super("DEVIS", singular, plural);
        this.getRowActions().addAll(this.getDevisRowActions());
        this.setDefaultGroup(new QuoteEditGroup());
    }

    private List<RowAction> getDevisRowActions() {
        ArrayList<RowAction> rowsActions = new ArrayList<RowAction>();
        RowAction factureAction = this.getDevis2FactureAction();
        rowsActions.add(factureAction);
        RowAction actionTransfertCmd = this.getDevis2CmdFournAction();
        rowsActions.add(actionTransfertCmd);
        RowAction commandeAction = this.getDevis2CmdCliAction();
        rowsActions.add(commandeAction);
        RowAction accepteEtCmdAction = this.getAcceptAndCmdClientAction();
        rowsActions.add(accepteEtCmdAction);
        RowAction accepteAction = this.getAcceptAction();
        rowsActions.add(accepteAction);
        RowAction refuseAction = this.getRefuseAction();
        rowsActions.add(refuseAction);
        RowAction cloneAction = this.getCloneAction();
        rowsActions.add(cloneAction);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(DevisXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        rowsActions.addAll(mouseSheetXmlListeListener.getRowActions());
        return rowsActions;
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction(){
            private EditFrame editFrame;

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowAccessor selectedRow = IListe.get(e).getSelectedRow();
                if (this.editFrame == null) {
                    SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("DEVIS");
                    this.editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                }
                ((DevisSQLComponent)this.editFrame.getSQLComponent()).loadDevisExistant(selectedRow.getID());
                this.editFrame.setVisible(true);
            }
        }, true, "sales.quote.clone"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }

    public RowAction getRefuseAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowVals = IListe.get(e).getSelectedRow().asRow().createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 3);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }, false, "sales.quote.refuse"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public RowAction getAcceptAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).getSelectedRow().asRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }, false, "sales.quote.accept"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public RowAction getDevis2FactureAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransfertBaseSQLComponent.openTransfertFrame(IListe.get(e).copySelectedRows(), "SAISIE_VENTE_FACTURE");
            }
        }, true, "sales.quote.create.invoice"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getDevis2CmdFournAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLRow selectedRow = IListe.get(e).fetchSelectedRow();
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        DevisSQLElement.this.transfertCommande(selectedRow);
                    }
                });
            }
        }, false, "sales.quote.create.supplier.order"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getDevis2CmdCliAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> copySelectedRows = IListe.get(e).copySelectedRows();
                DevisSQLElement.this.transfertCommandeClient(copySelectedRows);
            }
        }, true, "sales.quote.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getAcceptAndCmdClientAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).fetchSelectedRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Erreur la de la mise \u00e0 jour de l'\u00e9tat du devis!", e1);
                }
                DevisSQLElement.this.transfertCommandeClient(IListe.get(e).copySelectedRows());
            }
        }, false, "sales.quote.accept.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowAccessor> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getInt("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    private void transfertCommandeClient(final List<SQLRowValues> copySelectedRows) {
        SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                final SQLTable tableTransfert = DevisSQLElement.this.getTable().getTable("TR_DEVIS");
                SQLRowValues rowVals = new SQLRowValues(tableTransfert);
                rowVals.put("ID_DEVIS", new SQLRowValues(DevisSQLElement.this.getTable()).put("NUMERO", null));
                rowVals.put("ID_COMMANDE", null);
                rowVals.put("ID", null);
                final ArrayList<Integer> lID = new ArrayList<Integer>();
                for (SQLRowValues sqlRowValues : copySelectedRows) {
                    lID.add(sqlRowValues.getID());
                }
                SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
                fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    public SQLSelect transformChecked(SQLSelect input) {
                        Where w = new Where(tableTransfert.getField("ID_DEVIS"), lID);
                        w = w.and(new Where((FieldRef)tableTransfert.getField("ID_COMMANDE_CLIENT"), "IS NOT", (Object)null));
                        input.setWhere(w);
                        return input;
                    }
                });
                List<SQLRowValues> rows = fetch.fetch();
                if (rows != null && rows.size() > 0) {
                    String numero = "";
                    for (SQLRowValues sqlRow : rows) {
                        numero = String.valueOf(numero) + sqlRow.getForeign("ID_DEVIS").getString("NUMERO") + " ,";
                    }
                    numero = numero.substring(0, numero.length() - 2);
                    String label = "Attention ";
                    label = rows.size() > 1 ? String.valueOf(label) + " les devis " + numero + " ont d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9 en commande!" : String.valueOf(label) + " le devis " + numero + " a d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9 en commande!";
                    int ans = JOptionPane.showConfirmDialog(null, label = String.valueOf(label) + "\n Voulez vous continuer?", "Transfert devis en commande", 0);
                    if (ans == 1) {
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }

            @Override
            protected void done() {
                try {
                    Boolean b = (Boolean)this.get();
                    if (b != null && b.booleanValue()) {
                        TransfertBaseSQLComponent.openTransfertFrame(copySelectedRows, "COMMANDE_CLIENT");
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Erreur lors du transfert des devis en commande!", e);
                }
                super.done();
            }
        };
        worker.execute();
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    private void transfertCommande(final SQLRow row) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DevisItemSQLElement elt = (DevisItemSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
                SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
                SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
                Collection rows = row.getReferentRows(elt.getTable());
                ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
                SQLRow rowDeviseF = null;
                for (SQLRow sqlRow : rows) {
                    SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
                    for (SQLField field : eltArticle.getTable().getFields()) {
                        if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                        rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
                    }
                    int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
                    SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
                    SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
                    SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
                    rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
                    rowValsElt.put("QTE", sqlRow.getObject("QTE"));
                    rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
                    rowValsElt.put("T_PA_HT", ((BigDecimal)rowValsElt.getObject("PA_HT")).multiply(new BigDecimal(rowValsElt.getInt("QTE"), MathContext.DECIMAL128)));
                    rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(new BigDecimal((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), MathContext.DECIMAL128));
                    rowDeviseF = sqlRow.getForeignRow("ID_DEVISE");
                    SQLRow rowDeviseHA = rowArticleFind.getForeignRow("ID_DEVISE_HA");
                    BigDecimal qte = new BigDecimal(rowValsElt.getInt("QTE"));
                    if (rowDeviseF != null && !rowDeviseF.isUndefined()) {
                        if (rowDeviseF.getID() == rowDeviseHA.getID()) {
                            rowValsElt.put("PA_DEVISE", rowArticleFind.getObject("PA_DEVISE"));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowArticleFind.getObject("PA_DEVISE")).multiply(qte, MathContext.DECIMAL128));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        } else {
                            BigDecimal taux = (BigDecimal)rowDeviseF.getObject("TAUX");
                            rowValsElt.put("PA_DEVISE", taux.multiply((BigDecimal)rowValsElt.getObject("PA_HT")));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowValsElt.getObject("PA_DEVISE")).multiply(qte, MathContext.DECIMAL128));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        }
                    }
                    map.add(rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
                }
                MouvementStockSQLElement.createCommandeF(map, rowDeviseF);
            }
        });
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("OBJET");
        l.add("ID_COMMERCIAL");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("INFOS");
        return l;
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        CollectionMap<String, String> map = new CollectionMap<String, String>();
        map.put(null, (Object)"NUMERO");
        return map;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("ID_ETAT_DEVIS", null);
            }
        };
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("DEVIS_ELEMENT");
        return set;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> s = new ArrayList<String>(1);
        s.add("ID_ADRESSE");
        return s;
    }

    @Override
    public SQLComponent createComponent() {
        return new DevisSQLComponent(this);
    }
}

